/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouper.shibboleth.filter;

import edu.internet2.middleware.grouper.Group;
import edu.internet2.middleware.grouper.GrouperSession;
import edu.internet2.middleware.grouper.Stem;
import edu.internet2.middleware.grouper.StemFinder;
import edu.internet2.middleware.grouper.exception.GrouperException;
import edu.internet2.middleware.grouper.filter.GroupsInStemFilter;
import edu.internet2.middleware.grouper.filter.QueryFilter;
import edu.internet2.middleware.grouper.shibboleth.filter.BaseGroupQueryFilter;
import edu.internet2.middleware.grouper.util.GrouperUtil;

public class StemNameGroupFilter
extends BaseGroupQueryFilter {
    private String name;
    private Stem.Scope scope;

    public StemNameGroupFilter(String name, String scope) {
        this.name = name;
        this.scope = Stem.Scope.valueOf((String)scope);
        this.setQueryFilter((QueryFilter<Group>)new GroupsInStemFilter(name, this.scope, true));
    }

    @Override
    public boolean matchesGroup(Group group) {
        Stem stem = StemFinder.findByName((GrouperSession)this.getGrouperSession(), (String)this.name, (boolean)false);
        if (stem == null) {
            return false;
        }
        if (this.scope.equals((Object)Stem.Scope.SUB)) {
            return GrouperUtil.parentStemNameFromName((String)group.getName()).startsWith(stem.getName());
        }
        if (this.scope.equals((Object)Stem.Scope.ONE)) {
            return GrouperUtil.parentStemNameFromName((String)group.getName()).equals(stem.getName());
        }
        throw new GrouperException("Unknown scope " + this.scope);
    }
}

