/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouper.shibboleth.dataConnector.field;

import edu.internet2.middleware.grouper.Field;
import edu.internet2.middleware.grouper.Group;
import edu.internet2.middleware.grouper.Member;
import edu.internet2.middleware.grouper.Membership;
import edu.internet2.middleware.grouper.exception.SchemaException;
import edu.internet2.middleware.grouper.util.GrouperUtil;
import edu.internet2.middleware.subject.Subject;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public enum FieldMemberFilter {
    all{

        @Override
        protected Set<Member> getMembersHelper(Group group, Field field) throws SchemaException {
            return field == null ? group.getMembers() : group.getMembers(field);
        }

        @Override
        protected Set<Membership> getMembershipsHelper(Group group, Field field) throws SchemaException {
            return field == null ? group.getMemberships() : group.getMemberships(field);
        }

        @Override
        protected boolean hasMemberHelper(Group group, Subject subject, Field field) throws SchemaException {
            return field == null ? group.hasMember(subject) : group.hasMember(subject, field);
        }

        @Override
        public Set<Group> getGroups(Member member) {
            return GrouperUtil.nonNull((Set)member.getGroups());
        }

        @Override
        public Set<Group> getGroups(Member member, Field field) {
            return GrouperUtil.nonNull((Set)member.getGroups(field));
        }
    }
    ,
    effective{

        @Override
        protected Set<Member> getMembersHelper(Group group, Field field) throws SchemaException {
            return field == null ? group.getEffectiveMembers() : group.getEffectiveMembers(field);
        }

        @Override
        protected Set<Membership> getMembershipsHelper(Group group, Field field) throws SchemaException {
            return field == null ? group.getEffectiveMemberships() : group.getEffectiveMemberships(field);
        }

        @Override
        protected boolean hasMemberHelper(Group group, Subject subject, Field field) throws SchemaException {
            return field == null ? group.hasEffectiveMember(subject) : group.hasEffectiveMember(subject, field);
        }

        @Override
        public Set<Group> getGroups(Member member) {
            return GrouperUtil.nonNull((Set)member.getEffectiveGroups());
        }

        @Override
        public Set<Group> getGroups(Member member, Field field) {
            return GrouperUtil.nonNull((Set)member.getEffectiveGroups(field));
        }
    }
    ,
    immediate{

        @Override
        protected Set<Member> getMembersHelper(Group group, Field field) throws SchemaException {
            return field == null ? group.getImmediateMembers() : group.getImmediateMembers(field);
        }

        @Override
        protected Set<Membership> getMembershipsHelper(Group group, Field field) throws SchemaException {
            return field == null ? group.getImmediateMemberships() : group.getImmediateMemberships(field);
        }

        @Override
        protected boolean hasMemberHelper(Group group, Subject subject, Field field) throws SchemaException {
            return field == null ? group.hasImmediateMember(subject) : group.hasImmediateMember(subject, field);
        }

        @Override
        public Set<Group> getGroups(Member member) {
            return GrouperUtil.nonNull((Set)member.getImmediateGroups());
        }

        @Override
        public Set<Group> getGroups(Member member, Field field) {
            return GrouperUtil.nonNull((Set)member.getImmediateGroups(field));
        }
    }
    ,
    composite{

        @Override
        protected Set<Member> getMembersHelper(Group group, Field field) {
            return GrouperUtil.nonNull((Set)group.getCompositeMembers());
        }

        @Override
        protected Set<Membership> getMembershipsHelper(Group group, Field field) {
            if (field != null) {
                throw new RuntimeException("Field '" + field.getName() + "' cannot be nonnull if member filter is composite");
            }
            return group.getCompositeMemberships();
        }

        @Override
        protected boolean hasMemberHelper(Group group, Subject subject, Field field) {
            throw new RuntimeException("hasMember with composite is not supported: groupName: " + group.getName() + ", subject: " + subject.getName() + ", field: " + field.getName());
        }

        @Override
        public Set<Group> getGroups(Member member) {
            throw new RuntimeException("getGroups with composite is not supported: member subject id: " + member.getSubjectId());
        }

        @Override
        public Set<Group> getGroups(Member member, Field field) {
            throw new RuntimeException("getGroups with composite is not supported: member subject id: " + member.getSubjectId());
        }
    };


    public final Set<Member> getMembers(Group group, Field field) {
        try {
            return this.getMembersHelper(group, field);
        }
        catch (SchemaException se) {
            throw new RuntimeException("Problem with group and field: " + group + ", field: " + field.getName(), se);
        }
    }

    protected abstract Set<Member> getMembersHelper(Group var1, Field var2) throws SchemaException;

    protected abstract Set<Membership> getMembershipsHelper(Group var1, Field var2) throws SchemaException;

    public final Set<Membership> getMemberships(Group group, Field field) {
        try {
            return this.getMembershipsHelper(group, field);
        }
        catch (SchemaException se) {
            throw new RuntimeException("Problem with group and field: " + group + ", field: " + field.getName(), se);
        }
    }

    protected abstract boolean hasMemberHelper(Group var1, Subject var2, Field var3) throws SchemaException;

    public final boolean hasMember(Group group, Subject subject, Field field) {
        try {
            return this.hasMemberHelper(group, subject, field);
        }
        catch (SchemaException se) {
            throw new RuntimeException("Problem with group and field: " + group + ", field: " + field.getName(), se);
        }
    }

    public abstract Set<Group> getGroups(Member var1);

    public abstract Set<Group> getGroups(Member var1, Field var2);

    public static FieldMemberFilter valueOfIgnoreCase(String string) {
        return FieldMemberFilter.enumValueOfIgnoreCase(FieldMemberFilter.class, string, false);
    }

    public static <E extends Enum<?>> E enumValueOfIgnoreCase(Class<E> theEnumClass, String string, boolean exceptionOnNotFound) throws RuntimeException {
        if (!exceptionOnNotFound && StringUtils.isBlank((String)string)) {
            System.err.println("getenum " + null);
            return null;
        }
        for (Enum e : (Enum[])theEnumClass.getEnumConstants()) {
            System.err.println("getenum " + e);
        }
        for (Enum e : (Enum[])theEnumClass.getEnumConstants()) {
            if (!StringUtils.equalsIgnoreCase((String)string, (String)e.name())) continue;
            return (E)e;
        }
        StringBuilder error = new StringBuilder("Cant find " + theEnumClass.getSimpleName() + " from string: '").append(string);
        error.append("', expecting one of: ");
        for (Enum e : (Enum[])theEnumClass.getEnumConstants()) {
            error.append(e.name()).append(", ");
        }
        throw new RuntimeException(error.toString());
    }
}

