/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouper.shibboleth.dataConnector.field;

import edu.internet2.middleware.grouper.exception.GrouperException;
import edu.internet2.middleware.grouper.util.GrouperUtil;
import java.util.List;

public class BaseField {
    public static final String DELIMITER = ":";
    private String id;
    private List<String> idElements;

    public BaseField(String id) throws GrouperException {
        if (id == null || id.equals("")) {
            throw new GrouperException("The id must not be null nor empty.");
        }
        this.id = id;
        this.idElements = GrouperUtil.splitTrimToList((String)id, (String)DELIMITER);
        if (this.idElements.size() > 3) {
            throw new GrouperException("Invalid id '" + id + "', there should be a maximum of 3 elements.");
        }
    }

    public String getId() {
        return this.id;
    }

    public List<String> getIdElements() {
        return this.idElements;
    }

    public String getFirstIdElement() {
        return this.idElements.get(0);
    }

    public String getSecondIdElement() {
        return this.idElements.get(1);
    }

    public String getThirdIdElement() {
        return this.idElements.get(2);
    }
}

