/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouper.shibboleth.dataConnector;

import edu.internet2.middleware.grouper.Attribute;
import edu.internet2.middleware.grouper.Group;
import edu.internet2.middleware.grouper.GroupFinder;
import edu.internet2.middleware.grouper.GrouperSession;
import edu.internet2.middleware.grouper.Member;
import edu.internet2.middleware.grouper.exception.GrouperSessionException;
import edu.internet2.middleware.grouper.misc.GrouperSessionHandler;
import edu.internet2.middleware.grouper.shibboleth.dataConnector.BaseGrouperDataConnector;
import edu.internet2.middleware.grouper.shibboleth.dataConnector.field.GroupsField;
import edu.internet2.middleware.grouper.shibboleth.dataConnector.field.MembersField;
import edu.internet2.middleware.grouper.shibboleth.dataConnector.field.PrivilegeField;
import edu.internet2.middleware.grouper.util.GrouperUtil;
import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.provider.BasicAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.AttributeResolutionException;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.ShibbolethResolutionContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupDataConnector
extends BaseGrouperDataConnector {
    private static final Logger LOG = LoggerFactory.getLogger(GroupDataConnector.class);

    public Map<String, BaseAttribute> resolve(final ShibbolethResolutionContext resolutionContext) throws AttributeResolutionException {
        Map attributes = (Map)GrouperSession.callbackGrouperSession((GrouperSession)this.getGrouperSession(), (GrouperSessionHandler)new GrouperSessionHandler(){

            public Map<String, BaseAttribute> callback(GrouperSession grouperSession) throws GrouperSessionException {
                BaseAttribute<Member> attr;
                BasicAttribute basicAttribute;
                String principalName = resolutionContext.getAttributeRequestContext().getPrincipalName();
                String msg = "'" + principalName + "' dc '" + GroupDataConnector.this.getId() + "'";
                LOG.debug("resolve {}", (Object)msg);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("resolve {} requested attribute ids {}", (Object)msg, (Object)resolutionContext.getAttributeRequestContext().getRequestedAttributesIds());
                    if (resolutionContext.getAttributeRequestContext().getRequestedAttributesIds() != null) {
                        for (String attrId : resolutionContext.getAttributeRequestContext().getRequestedAttributesIds()) {
                            LOG.trace("resolve {} requested attribute '{}'", (Object)msg, (Object)attrId);
                        }
                    }
                }
                LinkedHashMap<String, BaseAttribute> attributes = new LinkedHashMap<String, BaseAttribute>();
                Group group = GroupFinder.findByName((GrouperSession)GroupDataConnector.this.getGrouperSession(), (String)principalName, (boolean)false);
                if (group == null) {
                    LOG.debug("resolve {} group not found", (Object)msg);
                    return attributes;
                }
                LOG.debug("resolve {} found group '{}'", (Object)msg, (Object)group);
                if (GroupDataConnector.this.getGroupQueryFilter() != null) {
                    if (!GroupDataConnector.this.getGroupQueryFilter().matchesGroup(group)) {
                        LOG.debug("resolve {} group {} does not match filter", (Object)msg, (Object)group);
                        return attributes;
                    }
                    LOG.debug("resolve {} group {} matches filter", (Object)msg, (Object)group);
                }
                for (String attributeName : Group.INTERNAL_FIELD_ATTRIBUTES) {
                    String value = (String)GrouperUtil.fieldValue((Object)group, (String)attributeName);
                    if (value == null) continue;
                    basicAttribute = new BasicAttribute(attributeName);
                    basicAttribute.setValues(Arrays.asList(value));
                    attributes.put(attributeName, (BaseAttribute)basicAttribute);
                }
                for (String attributeDefName : GroupDataConnector.this.getAttributeDefNames()) {
                    List values = group.getAttributeValueDelegate().retrieveValuesString(attributeDefName);
                    if (values == null || values.isEmpty()) continue;
                    basicAttribute = new BasicAttribute(attributeDefName);
                    basicAttribute.setValues((Collection)values);
                    attributes.put(attributeDefName, (BaseAttribute)basicAttribute);
                }
                Map customAttributes = group.getAttributesMap(false);
                for (String attributeName : customAttributes.keySet()) {
                    String value = ((Attribute)customAttributes.get(attributeName)).getValue();
                    if (value == null) continue;
                    BasicAttribute basicAttribute2 = new BasicAttribute(attributeName);
                    basicAttribute2.setValues(Arrays.asList(value));
                    attributes.put(attributeName, (BaseAttribute)basicAttribute2);
                }
                for (MembersField membersField : GroupDataConnector.this.getMembersFields()) {
                    attr = membersField.getAttribute(group);
                    if (attr == null) continue;
                    attributes.put(membersField.getId(), attr);
                }
                for (GroupsField groupsField : GroupDataConnector.this.getGroupsFields()) {
                    attr = groupsField.getAttribute(group.toMember());
                    if (attr == null) continue;
                    attributes.put(groupsField.getId(), attr);
                }
                for (PrivilegeField privilegeField : GroupDataConnector.this.getPrivilegeFields()) {
                    attr = privilegeField.getAttribute(group);
                    if (attr == null) continue;
                    attributes.put(privilegeField.getId(), attr);
                }
                BasicAttribute stem = new BasicAttribute("parentStemName");
                stem.setValues(Arrays.asList(group.getParentStemName()));
                attributes.put(stem.getId(), (BaseAttribute)stem);
                BasicAttribute groupTypes = new BasicAttribute("groupType");
                groupTypes.setValues((Collection)group.getTypes());
                attributes.put(groupTypes.getId(), (BaseAttribute)groupTypes);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("resolve {} attributes {}", (Object)msg, (Object)attributes.size());
                    for (String key : attributes.keySet()) {
                        for (Object value : ((BaseAttribute)attributes.get(key)).getValues()) {
                            LOG.debug("resolve {} '{}' : {}", new Object[]{msg, key, value});
                        }
                    }
                }
                return attributes;
            }
        });
        return attributes;
    }

    public void validate() throws AttributeResolutionException {
    }

    @Override
    public Set<String> getAllIdentifiers() {
        return this.getAllIdentifiers(null);
    }

    @Override
    public Set<String> getAllIdentifiers(Date updatedSince) {
        TreeSet<String> identifiers = new TreeSet<String>();
        for (Group group : this.getGroups(updatedSince)) {
            identifiers.add(group.getName());
        }
        return identifiers;
    }
}

