/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouper.shibboleth.dataConnector;

import edu.internet2.middleware.grouper.Group;
import edu.internet2.middleware.grouper.GrouperSession;
import edu.internet2.middleware.grouper.Stem;
import edu.internet2.middleware.grouper.StemFinder;
import edu.internet2.middleware.grouper.SubjectFinder;
import edu.internet2.middleware.grouper.attr.AttributeDefName;
import edu.internet2.middleware.grouper.exception.GrouperException;
import edu.internet2.middleware.grouper.exception.GrouperSessionException;
import edu.internet2.middleware.grouper.misc.GrouperDAOFactory;
import edu.internet2.middleware.grouper.misc.GrouperSessionHandler;
import edu.internet2.middleware.grouper.privs.AccessPrivilege;
import edu.internet2.middleware.grouper.shibboleth.dataConnector.SourceDataConnector;
import edu.internet2.middleware.grouper.shibboleth.dataConnector.field.BaseField;
import edu.internet2.middleware.grouper.shibboleth.dataConnector.field.GroupsField;
import edu.internet2.middleware.grouper.shibboleth.dataConnector.field.MembersField;
import edu.internet2.middleware.grouper.shibboleth.dataConnector.field.PrivilegeField;
import edu.internet2.middleware.grouper.shibboleth.filter.ConditionalGroupQueryFilter;
import edu.internet2.middleware.grouper.shibboleth.filter.GroupQueryFilter;
import edu.internet2.middleware.grouper.shibboleth.util.AttributeIdentifier;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector.BaseDataConnector;
import edu.internet2.middleware.subject.Source;
import edu.internet2.middleware.subject.Subject;
import edu.internet2.middleware.subject.SubjectNotFoundException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseGrouperDataConnector
extends BaseDataConnector
implements SourceDataConnector {
    private static final Logger LOG = LoggerFactory.getLogger(BaseGrouperDataConnector.class);
    public static final String GROUP_TYPE_ATTR = "groupType";
    public static final String PARENT_STEM_NAME_ATTR = "parentStemName";
    private GrouperSession grouperSession;
    private List<AttributeIdentifier> fieldIdentifiers;
    private ArrayList<GroupsField> groupsFields = new ArrayList();
    private ArrayList<MembersField> membersFields = new ArrayList();
    private ArrayList<PrivilegeField> privilegeFields = new ArrayList();
    private List<AttributeIdentifier> subjectAttributeIdentifiers = new ArrayList<AttributeIdentifier>();
    private Set<String> sourceIds;
    private GroupQueryFilter groupQueryFilter;
    private Set<String> validFirstIdElements = new HashSet<String>();
    private AttributeIdentifier subjectIdentifier;
    private Set<String> attributeDefNames = new LinkedHashSet<String>();

    public void initialize() throws GrouperException {
        this.getGrouperSession();
        LOG.info("started grouper session '" + this.getGrouperSession() + "' for '" + this.getId() + "'");
        this.validFirstIdElements.add("groups");
        this.validFirstIdElements.add("members");
        this.validFirstIdElements.addAll(AccessPrivilege.getAllPrivilegeNames());
        this.validFirstIdElements.addAll(this.getAllAttributeDefNames());
        for (AttributeIdentifier fieldIdentifier : this.fieldIdentifiers) {
            LOG.debug("attribute identifier '{}' for dc '{}'", (Object)fieldIdentifier, (Object)this.getId());
            if (fieldIdentifier.getSource().equals(SubjectFinder.internal_getGSA().getId())) {
                BaseField bf = new BaseField(fieldIdentifier.getId());
                if (!this.validFirstIdElements.contains(bf.getFirstIdElement()) && !this.validFirstIdElements.contains(fieldIdentifier.getId())) {
                    LOG.error("Invalid identifer '" + fieldIdentifier.getId() + "', should start with one of " + this.validFirstIdElements);
                    throw new GrouperException("Invalid identifer '" + fieldIdentifier.getId() + "', should start with one of " + this.validFirstIdElements);
                }
                if (bf.getFirstIdElement().equals("groups")) {
                    this.groupsFields.add(new GroupsField(fieldIdentifier.getId()));
                    continue;
                }
                if (bf.getFirstIdElement().equals("members")) {
                    this.membersFields.add(new MembersField(fieldIdentifier.getId()));
                    continue;
                }
                if (AccessPrivilege.getAllPrivilegeNames().contains(fieldIdentifier.getId())) {
                    this.privilegeFields.add(new PrivilegeField(fieldIdentifier.getId(), this.getGrouperSession().getAccessResolver()));
                    continue;
                }
                if (this.getAllAttributeDefNames().contains(fieldIdentifier.getId())) {
                    this.attributeDefNames.add(fieldIdentifier.getId());
                    continue;
                }
                LOG.error("Unknown field identifier {}", (Object)fieldIdentifier.getId());
                throw new GrouperException("Unknown field identifier " + fieldIdentifier.getId());
            }
            if (!this.getSourceIds().contains(fieldIdentifier.getSource())) {
                LOG.error("Unknown source '" + fieldIdentifier.getSource() + "'");
                throw new GrouperException("Unknown source '" + fieldIdentifier.getSource() + "'");
            }
            this.subjectAttributeIdentifiers.add(fieldIdentifier);
        }
        this.privilegeFields.trimToSize();
        this.membersFields.trimToSize();
        this.groupsFields.trimToSize();
        if (this.groupQueryFilter != null) {
            this.groupQueryFilter.setGrouperSession(this.grouperSession);
            if (this.groupQueryFilter instanceof ConditionalGroupQueryFilter) {
                ((ConditionalGroupQueryFilter)this.groupQueryFilter).getGroupFilter0().setGrouperSession(this.grouperSession);
                ((ConditionalGroupQueryFilter)this.groupQueryFilter).getGroupFilter1().setGrouperSession(this.grouperSession);
            }
        }
    }

    public GrouperSession getGrouperSession() throws SubjectNotFoundException {
        if (this.grouperSession == null) {
            if (this.subjectIdentifier == null) {
                this.grouperSession = GrouperSession.startRootSession((boolean)false);
            } else {
                Subject subject = SubjectFinder.findByIdAndSource((String)this.subjectIdentifier.getId(), (String)this.subjectIdentifier.getSource(), (boolean)true);
                this.grouperSession = GrouperSession.start((Subject)subject, (boolean)false);
            }
            LOG.debug("started grouper session {}", (Object)this.grouperSession);
        }
        return this.grouperSession;
    }

    public GroupQueryFilter getGroupQueryFilter() {
        return this.groupQueryFilter;
    }

    public void setGroupQueryFilter(GroupQueryFilter groupQueryFilter) {
        this.groupQueryFilter = groupQueryFilter;
    }

    public void setFieldIdentifiers(List<AttributeIdentifier> fieldIdentifiers) {
        this.fieldIdentifiers = fieldIdentifiers;
    }

    public List<GroupsField> getGroupsFields() {
        return this.groupsFields;
    }

    public List<MembersField> getMembersFields() {
        return this.membersFields;
    }

    public List<PrivilegeField> getPrivilegeFields() {
        return this.privilegeFields;
    }

    private Set<String> getSourceIds() {
        if (this.sourceIds == null) {
            this.sourceIds = new HashSet<String>();
            for (Source source : SubjectFinder.getSources()) {
                this.sourceIds.add(source.getId());
            }
        }
        return this.sourceIds;
    }

    public List<AttributeIdentifier> getSubjectAttributeIdentifiers() {
        return this.subjectAttributeIdentifiers;
    }

    public AttributeIdentifier getSubjectIdentifier() {
        return this.subjectIdentifier;
    }

    public void setSubjectIdentifier(AttributeIdentifier subjectIdentifier) {
        this.subjectIdentifier = subjectIdentifier;
    }

    public Set<Group> getGroups(final Date lastModifyTime) {
        Set groups = (Set)GrouperSession.callbackGrouperSession((GrouperSession)this.getGrouperSession(), (GrouperSessionHandler)new GrouperSessionHandler(){

            public Set<Group> callback(GrouperSession grouperSession) throws GrouperSessionException {
                String msg = "get groups since '" + lastModifyTime + "' for '" + BaseGrouperDataConnector.this.getId() + "'";
                LOG.debug(msg);
                TreeSet<Group> groups = new TreeSet<Group>();
                GroupQueryFilter filter = BaseGrouperDataConnector.this.getGroupQueryFilter();
                if (filter == null) {
                    Stem root = StemFinder.findRootStem((GrouperSession)grouperSession);
                    groups.addAll(root.getChildGroups(Stem.Scope.SUB));
                } else {
                    groups.addAll(BaseGrouperDataConnector.this.getGroupQueryFilter().getResults(grouperSession));
                }
                LOG.debug("{} found {} before filtering", (Object)msg, (Object)groups.size());
                if (lastModifyTime != null) {
                    Iterator iterator = groups.iterator();
                    while (iterator.hasNext()) {
                        Date memberModifyTime;
                        Group group = (Group)iterator.next();
                        if (group.getCreateTime().after(lastModifyTime) || group.getModifyTime().after(lastModifyTime) || group.getLastMembershipChange() != null && (memberModifyTime = new Date(group.getLastMembershipChange().getTime())).after(lastModifyTime)) continue;
                        iterator.remove();
                    }
                }
                LOG.debug("{} found {}", (Object)msg, (Object)groups.size());
                return groups;
            }
        });
        return groups;
    }

    protected Set<String> getAttributeDefNames() {
        return this.attributeDefNames;
    }

    protected Set<String> getAllAttributeDefNames() {
        HashSet<String> allAttributeDefNames = new HashSet<String>();
        Set attributeDefNames = GrouperDAOFactory.getFactory().getAttributeDefName().findAllAttributeNamesSplitScopeSecure(null, this.getGrouperSession(), null, SubjectFinder.findRootSubject(), null, null, null, null);
        for (AttributeDefName attributeDefName : attributeDefNames) {
            allAttributeDefNames.add(attributeDefName.getName());
        }
        return allAttributeDefNames;
    }
}

