/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouper.shibboleth.attributeDefinition;

import edu.internet2.middleware.grouper.shibboleth.util.AttributeIdentifier;
import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.provider.BasicAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.AttributeResolutionException;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.ShibbolethResolutionContext;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.attributeDefinition.BaseAttributeDefinition;
import edu.internet2.middleware.subject.Subject;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAttributeDefinition
extends BaseAttributeDefinition {
    private static Logger LOG = LoggerFactory.getLogger(SubjectAttributeDefinition.class);
    private List<AttributeIdentifier> attributes;

    public void setAttributes(List<AttributeIdentifier> attributes) {
        this.attributes = attributes;
    }

    protected BaseAttribute doResolve(ShibbolethResolutionContext resolutionContext) throws AttributeResolutionException {
        String principalName = resolutionContext.getAttributeRequestContext().getPrincipalName();
        String msg = "resolve '" + principalName + "' ad '" + this.getId() + "'";
        LOG.debug("{}", (Object)msg);
        BasicAttribute attribute = new BasicAttribute(this.getId());
        Collection values = this.getValuesFromAllDependencies(resolutionContext);
        if (LOG.isDebugEnabled()) {
            for (Object value : values) {
                LOG.debug("{} values from dependencies '{}'", (Object)msg, value);
            }
        }
        if (values == null) {
            LOG.debug("{} no dependency values", (Object)msg);
            return attribute;
        }
        for (Object value : values) {
            if (!(value instanceof Subject)) {
                LOG.error("{} Unable to resolve attribute, dependency value is not a Subject : {}", (Object)msg, value.getClass());
                throw new AttributeResolutionException("Unable to resolve attribute, dependency value is not a Subject");
            }
            Subject subject = (Subject)value;
            String sourceId = subject.getSource().getId();
            for (AttributeIdentifier attr : this.attributes) {
                if (!sourceId.equals(attr.getSource())) continue;
                Set<String> subjectValues = null;
                if (attr.getId().equalsIgnoreCase("id")) {
                    subjectValues = new HashSet<String>();
                    subjectValues.add(subject.getId());
                } else if (attr.getId().equalsIgnoreCase("name")) {
                    subjectValues = new HashSet();
                    subjectValues.add(subject.getName());
                } else if (attr.getId().equalsIgnoreCase("description")) {
                    subjectValues = new HashSet();
                    subjectValues.add(subject.getDescription());
                } else {
                    subjectValues = subject.getAttributeValues(attr.getId());
                }
                if (subjectValues == null) continue;
                attribute.getValues().addAll(subjectValues);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} values {}", (Object)msg, (Object)attribute.getValues().size());
            for (Object value : attribute.getValues()) {
                LOG.debug("{} value '{}'", (Object)msg, value);
            }
        }
        return attribute;
    }

    public void validate() throws AttributeResolutionException {
    }
}

