/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouper.shibboleth.attributeDefinition;

import edu.internet2.middleware.grouper.Group;
import edu.internet2.middleware.grouper.SubjectFinder;
import edu.internet2.middleware.grouper.shibboleth.util.AttributeIdentifier;
import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.provider.BasicAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.AttributeResolutionException;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.ShibbolethResolutionContext;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.attributeDefinition.BaseAttributeDefinition;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupAttributeDefinition
extends BaseAttributeDefinition {
    private static Logger LOG = LoggerFactory.getLogger(GroupAttributeDefinition.class);
    private List<AttributeIdentifier> attributes;

    public void setAttributes(List<AttributeIdentifier> attributes) {
        this.attributes = attributes;
    }

    protected BaseAttribute doResolve(ShibbolethResolutionContext resolutionContext) throws AttributeResolutionException {
        String principalName = resolutionContext.getAttributeRequestContext().getPrincipalName();
        String msg = "resolve '" + principalName + "' ad '" + this.getId() + "'";
        LOG.debug("{}", (Object)msg);
        BasicAttribute attribute = new BasicAttribute(this.getId());
        Collection values = this.getValuesFromAllDependencies(resolutionContext);
        if (LOG.isDebugEnabled()) {
            for (Object value : values) {
                LOG.debug("{} values from dependencies '{}'", (Object)msg, value);
            }
        }
        if (values == null) {
            LOG.debug("{} no dependency values", (Object)msg);
            return attribute;
        }
        for (Object value : values) {
            if (!(value instanceof Group)) {
                LOG.error("{} Unable to resolve attribute, dependency value is not a Group : {}", (Object)msg, value.getClass());
                throw new AttributeResolutionException("Unable to resolve attribute, dependency value is not a Group");
            }
            Group group = (Group)value;
            for (AttributeIdentifier attr : this.attributes) {
                if (!attr.getSource().equals(SubjectFinder.internal_getGSA().getId())) continue;
                attribute.getValues().add(group.getAttributeOrFieldValue(attr.getId(), false, false));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} values {}", (Object)msg, (Object)attribute.getValues().size());
            for (Object value : attribute.getValues()) {
                LOG.debug("{} value '{}'", (Object)msg, value);
            }
        }
        return attribute;
    }

    public void validate() throws AttributeResolutionException {
    }
}

