/*
 * Decompiled with CFR 0.152.
 */
package edu.upenn.isc.fast.websec;

import edu.upenn.isc.fast.log.FastLoggerExternal;
import edu.upenn.isc.fast.util.FastExternalUtils;
import edu.upenn.isc.fast.util.FastPropertyFileUtils;
import edu.upenn.isc.fast.websec.WebsecClient;
import edu.upenn.isc.fast.websec.WebsecOutput;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import oracle.security.sso.ias904.toolkit.IPASAuthException;
import oracle.security.sso.ias904.toolkit.IPASAuthInterface;
import oracle.security.sso.ias904.toolkit.IPASInsufficientCredException;
import oracle.security.sso.ias904.toolkit.IPASUserInfo;

public class WebsecSingleSignonOracle
implements IPASAuthInterface {
    private static final String HOME_DIR = System.getProperty("user.dir");
    private static final String PROPERTIES_FILE = HOME_DIR + "/fast/websecSso.properties";
    private static final FastLoggerExternal log;

    public static void saveStringIntoFile(File file, String contents) {
        try {
            WebsecSingleSignonOracle.writeStringToFile(file, contents, "ISO-8859-1");
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringToFile(File file, String data, String encoding) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        try {
            ((OutputStream)out).write(data.getBytes(encoding));
        }
        finally {
            WebsecSingleSignonOracle.closeQuietly(out);
        }
    }

    public static void closeQuietly(OutputStream output) {
        if (output == null) {
            return;
        }
        try {
            output.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String cookieValue(HttpServletRequest request, String cookieName, boolean expire) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        for (int i = 0; i < cookies.length; ++i) {
            if (!FastExternalUtils.equals(cookies[i].getName(), cookieName)) continue;
            if (expire) {
                cookies[i].setMaxAge(0);
            }
            return cookies[i].getValue();
        }
        return null;
    }

    public IPASUserInfo authenticate(HttpServletRequest request) throws IPASAuthException, IPASInsufficientCredException {
        log.log("WebsecSingleSignon.authenticate() called", true);
        log.logServletRequest(request, true);
        String websecToken = request.getParameter("websec_token");
        String pennkey = null;
        if (websecToken == null || websecToken.length() == 0) {
            websecToken = WebsecSingleSignonOracle.cookieValue(request, "websec_token", true);
            if (websecToken == null || websecToken.length() == 0) {
                String message = "Websec token not detected in URL!";
                log.log(message, true);
                log.logServletRequest(request, true);
                throw new IPASInsufficientCredException(message);
            }
            log.log("Websec token found in cookie!", true);
        } else {
            log.log("Websec token found in URL!", true);
        }
        pennkey = WebsecSingleSignonOracle.websecPennkey(websecToken);
        IPASUserInfo userInfo = new IPASUserInfo(pennkey);
        return userInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String websecPennkey(String websecToken) {
        String websecPrefix = websecToken == null ? null : websecToken.substring(0, 5);
        log.log("Decoding token starting with: " + websecPrefix, true);
        StringBuffer theLog = new StringBuffer();
        boolean verbose = FastPropertyFileUtils.retrievePropertyBoolean(PROPERTIES_FILE, "verboseLogging");
        String websecAppName = FastPropertyFileUtils.retrievePropertyString(PROPERTIES_FILE, "websecAppName");
        String websecBinary = FastPropertyFileUtils.retrievePropertyString(PROPERTIES_FILE, "websecBinary");
        WebsecOutput websecOutput = null;
        try {
            websecOutput = WebsecClient.callWebsecClient(websecToken, websecAppName, theLog, verbose, websecBinary);
            Object var8_7 = null;
            if (theLog.length() > 0) {
                String logMessage = theLog.toString();
                log.log(logMessage, false);
                System.err.println(logMessage);
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (theLog.length() > 0) {
                String logMessage = theLog.toString();
                log.log(logMessage, false);
                System.err.println(logMessage);
            }
            throw throwable;
        }
        if (verbose) {
            String logMessage = websecOutput.toString();
            log.log(logMessage, true);
            System.err.println(logMessage);
        }
        return websecOutput.getPennkey();
    }

    public URL getUserCredentialPage(HttpServletRequest request, String arg1) {
        log.log("WebsecSingleSignon.getUserCredentialPage() called: " + arg1, true);
        log.logServletRequest(request, true);
        String url = FastPropertyFileUtils.retrievePropertyString(PROPERTIES_FILE, "websecUrl");
        String site2pstoretokenName = "site2pstoretoken";
        String site2pstoreToken = request.getParameter(site2pstoretokenName);
        if (FastExternalUtils.isNotEmpty(site2pstoreToken)) {
            url = url + (FastExternalUtils.contains(url, "?") ? "&" : "?");
            url = url + site2pstoretokenName + "=" + FastExternalUtils.encodeForUrl(site2pstoreToken);
            log.log("Adding site2storeptoken to url", true);
        } else {
            log.log("Could not find site2pstoretoken", true);
        }
        log.log("Url to redirect to is: " + url, true);
        try {
            return new URL(url);
        }
        catch (Exception e) {
            String logMessage = "Problem with url: " + url;
            log.log(logMessage, false);
            throw new RuntimeException(logMessage, e);
        }
    }

    public static void main(String[] args) {
        String websecToken = "cbe4c2d5990fb8b8f06a61936aff7dcd";
        if (args != null && args.length == 1) {
            websecToken = args[0];
        } else {
            System.out.println("Usage: program token\n");
        }
        System.out.println(WebsecSingleSignonOracle.websecPennkey(websecToken));
    }

    static {
        try {
            File tmp = new File("/tmp");
            if (tmp.exists() && tmp.isDirectory()) {
                File logFile = new File("/tmp/fastLog" + System.currentTimeMillis() + ".txt");
                WebsecSingleSignonOracle.saveStringIntoFile(logFile, "Property file is: " + PROPERTIES_FILE);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log = new FastLoggerExternal("logFile", PROPERTIES_FILE, "verboseLogging");
    }
}

