/*
 * Decompiled with CFR 0.152.
 */
package edu.upenn.isc.fast.websec;

import edu.upenn.isc.fast.util.FastExternalUtils;
import edu.upenn.isc.fast.websec.InvalidWebsecTokenException;
import edu.upenn.isc.fast.websec.TimedOutWebsecTokenException;
import edu.upenn.isc.fast.websec.WebsecException;
import edu.upenn.isc.fast.websec.WebsecOutput;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class WebsecClient {
    public static void callWebsecClientExpire(String websecToken, String[] websecAppNames, StringBuffer log, boolean isVerbose, String websecBinary) {
        int websecAppNamesLength = websecAppNames.length;
        for (int i = 0; i < websecAppNamesLength; ++i) {
            if (!WebsecClient.callWebsecClientExpire(websecToken, websecAppNames[i], log, isVerbose, websecBinary)) continue;
            return;
        }
        throw new RuntimeException("Could not expire websec token!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean callWebsecClientExpire(String websecToken, String websecAppName, StringBuffer log, boolean isVerbose, String websecBinary) {
        StringBuffer result;
        boolean foundError;
        boolean foundSuccess;
        block14: {
            if (websecBinary == null || websecBinary.length() == 0) {
                throw new RuntimeException("You need to configure where the websec binary is in the fastConfig.xml!");
            }
            Runtime runtime = Runtime.getRuntime();
            String command = websecBinary + " " + websecAppName + " expire_token " + websecToken;
            if (isVerbose) {
                log.append("Websec command is: ").append(command);
            }
            Process process = null;
            BufferedReader reader = null;
            foundSuccess = false;
            foundError = false;
            result = new StringBuffer();
            process = runtime.exec(command);
            reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (isVerbose) {
                    log.append("Websec response: ").append(line);
                }
                result.append(line);
                if (line.toLowerCase().indexOf("success") == -1) continue;
                foundSuccess = true;
            }
            Object var14_14 = null;
            try {
                reader.close();
            }
            catch (Exception e) {
                log.append(FastExternalUtils.getFullStackTrace(e));
            }
            break block14;
            {
                catch (IOException ioe) {
                    foundError = true;
                    Object var14_15 = null;
                    try {
                        reader.close();
                    }
                    catch (Exception e) {
                        log.append(FastExternalUtils.getFullStackTrace(e));
                    }
                }
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                try {
                    reader.close();
                }
                catch (Exception e) {
                    log.append(FastExternalUtils.getFullStackTrace(e));
                }
                throw throwable;
            }
        }
        if (!foundSuccess) {
            foundError = true;
        }
        if (foundError) {
            log.append("Problem expiring websec token! ").append(result.toString());
        }
        return foundSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static WebsecOutput callWebsecClient(String websecToken, String websecAppName, StringBuffer log, boolean isVerbose, String websecBinary) throws WebsecException {
        StringBuffer completeResponse;
        boolean foundSomething;
        WebsecOutput result;
        block31: {
            String line;
            String websecTimestamp;
            String websecIp;
            String pennNetId;
            String pennid;
            BufferedReader reader;
            Process process;
            block30: {
                Runtime runtime = Runtime.getRuntime();
                String command = websecBinary + " " + websecAppName + " query_token " + websecToken;
                if (isVerbose) {
                    log.append("Websec command is: ").append(command);
                }
                process = null;
                reader = null;
                pennid = null;
                pennNetId = null;
                websecIp = null;
                websecTimestamp = null;
                result = new WebsecOutput();
                foundSomething = false;
                completeResponse = new StringBuffer("\n");
                process = runtime.exec(command);
                line = null;
                reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                while ((line = reader.readLine()) != null) {
                    completeResponse.append("STDERR: ");
                    completeResponse.append(line);
                    completeResponse.append("\n");
                }
                Object var19_18 = null;
                try {
                    reader.close();
                }
                catch (Exception e2) {
                    log.append(FastExternalUtils.getFullStackTrace(e2));
                }
                break block30;
                {
                    catch (Exception e) {
                        log.append(FastExternalUtils.getFullStackTrace(e));
                        var19_18 = null;
                        try {
                            reader.close();
                        }
                        catch (Exception e2) {
                            log.append(FastExternalUtils.getFullStackTrace(e2));
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var19_19 = null;
                    try {
                        reader.close();
                    }
                    catch (Exception e2) {
                        log.append(FastExternalUtils.getFullStackTrace(e2));
                    }
                    throw throwable;
                }
            }
            reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                if (isVerbose) {
                    log.append("Websec response: ").append(line);
                }
                completeResponse.append(line);
                completeResponse.append("\n");
                if (line.toLowerCase().startsWith("301 invalid token")) {
                    throw new InvalidWebsecTokenException();
                }
                if (line.toLowerCase().startsWith("302 token timed out")) {
                    throw new TimedOutWebsecTokenException();
                }
                if (line.toLowerCase().startsWith("203-8-digit pennid")) {
                    pennid = line.substring(line.indexOf(9) + 1, line.length());
                    result.setPennid(pennid);
                    foundSomething = true;
                }
                if (line.toLowerCase().startsWith("203-pennnet id")) {
                    pennNetId = line.substring(line.indexOf(9) + 1, line.length());
                    result.setPennkey(pennNetId);
                    foundSomething = true;
                }
                if (line.toLowerCase().startsWith("203-timestamp")) {
                    websecTimestamp = line.substring(line.indexOf(9) + 1, line.length());
                    result.setTimestamp(websecTimestamp);
                    foundSomething = true;
                }
                if (!line.toLowerCase().startsWith("203 ip address")) continue;
                websecIp = line.substring(line.indexOf(9) + 1, line.length());
                result.setIpaddr(websecIp);
                foundSomething = true;
            }
            Object var22_26 = null;
            try {
                reader.close();
            }
            catch (Exception e3) {
                log.append(FastExternalUtils.getFullStackTrace(e3));
            }
            break block31;
            {
                catch (Exception e) {
                    String error = "Problem running the websec client";
                    String logError = error + " (" + websecAppName + ", " + websecToken + ")! " + completeResponse.toString();
                    if (e instanceof InvalidWebsecTokenException || e instanceof TimedOutWebsecTokenException) {
                        if (!FastExternalUtils.equals("abc", websecToken) && isVerbose) {
                            log.append(logError);
                        }
                    } else {
                        log.append(logError);
                    }
                    if (e instanceof InvalidWebsecTokenException || e instanceof TimedOutWebsecTokenException) {
                        throw (RuntimeException)e;
                    }
                    Object var22_27 = null;
                    try {
                        reader.close();
                    }
                    catch (Exception e3) {
                        log.append(FastExternalUtils.getFullStackTrace(e3));
                    }
                }
            }
            catch (Throwable throwable) {
                Object var22_28 = null;
                try {
                    reader.close();
                }
                catch (Exception e3) {
                    log.append(FastExternalUtils.getFullStackTrace(e3));
                }
                throw throwable;
            }
        }
        if (!foundSomething) {
            String error = "Problem running the websec client";
            log.append(error + " (" + websecAppName + ", " + websecToken + ")! " + completeResponse.toString());
            throw new WebsecException(error);
        }
        return result;
    }

    public static void main(String[] args) {
        String websecAppname = "flash_web";
        String websecToken = "948518289eec366f382d4c13272bfe84";
        String websecClient = "c:\\websec\\websec_client.exe";
        if (args != null && args.length == 3) {
            websecClient = args[0];
            websecAppname = args[1];
            websecToken = args[2];
        } else {
            System.out.println("Usage: program websecClient appName token\n");
        }
        WebsecOutput websecOutput = WebsecClient.callWebsecClient(websecToken, websecAppname, new StringBuffer(), false, websecClient);
        System.out.println(websecOutput);
    }
}

