/*
 * Decompiled with CFR 0.152.
 */
package edu.upenn.isc.fast.util;

import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class FastPropertyFileUtils {
    private static Map propertiesBeanMap = new HashMap();

    public static boolean retrievePropertyBoolean(String propertiesFileLocation, String key) {
        String booleanValue = FastPropertyFileUtils.retrievePropertyString(propertiesFileLocation, key);
        if (booleanValue.equalsIgnoreCase("true")) {
            return true;
        }
        if (booleanValue.equalsIgnoreCase("false")) {
            return false;
        }
        String logMessage = "Illegal value for boolean property, must be true of false: " + key + ", " + booleanValue;
        throw new RuntimeException(logMessage);
    }

    public static String retrievePropertyString(String propertiesFileLocation, String key) {
        Properties localProperties = FastPropertyFileUtils.retrieveProperties(propertiesFileLocation);
        String value = localProperties.getProperty(key);
        if (value == null) {
            String logMessage = "The key: '" + key + "' could not be found in the properties file: " + propertiesFileLocation;
            throw new RuntimeException(logMessage);
        }
        return value;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static synchronized Properties retrieveProperties(String propertiesFileLocation) {
        PropertyBean propertyBean = (PropertyBean)propertiesBeanMap.get(propertiesFileLocation);
        File propertyFile = null;
        if (propertyBean == null) {
            propertyFile = new File(propertiesFileLocation);
            if (!propertyFile.exists()) {
                throw new RuntimeException("Cant find properties file: " + propertiesFileLocation);
            }
            propertyBean = new PropertyBean();
            propertyBean.setPropertiesFile(propertyFile);
        }
        long lastReadProperties = propertyBean.getLastRead();
        propertyFile = propertyBean.getPropertiesFile();
        Properties properties = propertyBean.getProperties();
        if (properties != null && propertyFile != null && lastReadProperties == propertyFile.lastModified()) {
            return properties;
        }
        System.out.println("Properties file read from: " + propertiesFileLocation);
        properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(propertyFile);
                properties.load(fileInputStream);
            }
            catch (Exception e) {
                throw new RuntimeException("Error reading properties file: " + propertiesFileLocation, e);
            }
            Object var9_6 = null;
            {
            }
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            try {
                if (fileInputStream == null) throw throwable;
                fileInputStream.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        if (fileInputStream != null) {
            fileInputStream.close();
        }
        propertyBean.setLastRead(propertyFile.lastModified());
        propertyBean.setProperties(properties);
        propertiesBeanMap.put(propertiesFileLocation, propertyBean);
        return properties;
    }

    private static class PropertyBean {
        long lastRead;
        File propertiesFile;
        Properties properties;

        private PropertyBean() {
        }

        public long getLastRead() {
            return this.lastRead;
        }

        public void setLastRead(long theLastRead) {
            this.lastRead = theLastRead;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public void setProperties(Properties theProperties) {
            this.properties = theProperties;
        }

        public File getPropertiesFile() {
            return this.propertiesFile;
        }

        public void setPropertiesFile(File thePropertiesFile) {
            this.propertiesFile = thePropertiesFile;
        }
    }
}

