/*
 * Decompiled with CFR 0.152.
 */
package edu.upenn.isc.fast.util;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

public class FastExternalUtils {
    static final String WRAPPED_MARKER = " [wrapped] ";
    private static String[] CAUSE_METHOD_NAMES;
    private static final Method THROWABLE_CAUSE_METHOD;
    static /* synthetic */ Class class$java$lang$Throwable;

    public static String encodeForUrl(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
    }

    public static boolean contains(String string, String contains) {
        if (string == null) {
            return false;
        }
        return string.indexOf(contains) != -1;
    }

    public static void initFile(File file) {
        if (!file.exists()) {
            File parentFile = file.getParentFile();
            if (!parentFile.exists() && !parentFile.mkdirs()) {
                throw new RuntimeException("Cannot create parent dirs: " + parentFile.getAbsolutePath());
            }
            if (!parentFile.isDirectory()) {
                throw new RuntimeException("Parent file is not a directory! " + parentFile.getAbsolutePath());
            }
        }
    }

    public static void closeQuietly(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void addCauseMethodName(String methodName) {
        ArrayList list;
        if (FastExternalUtils.isNotEmpty(methodName) && !FastExternalUtils.isCauseMethodName(methodName) && (list = FastExternalUtils.getCauseMethodNameList()).add(methodName)) {
            CAUSE_METHOD_NAMES = FastExternalUtils.toArray(list);
        }
    }

    public static void removeCauseMethodName(String methodName) {
        ArrayList list;
        if (FastExternalUtils.isNotEmpty(methodName) && (list = FastExternalUtils.getCauseMethodNameList()).remove(methodName)) {
            CAUSE_METHOD_NAMES = FastExternalUtils.toArray(list);
        }
    }

    private static String[] toArray(List list) {
        return list.toArray(new String[list.size()]);
    }

    private static ArrayList getCauseMethodNameList() {
        return new ArrayList<String>(Arrays.asList(CAUSE_METHOD_NAMES));
    }

    public static boolean isCauseMethodName(String methodName) {
        return FastExternalUtils.indexOf(CAUSE_METHOD_NAMES, methodName) >= 0;
    }

    public static Throwable getCause(Throwable throwable) {
        return FastExternalUtils.getCause(throwable, CAUSE_METHOD_NAMES);
    }

    public static String className(Object object) {
        return object == null ? null : object.getClass().getName();
    }

    public static Object executeMethod(Object object, String methodName) {
        try {
            Class<?> theClass = object.getClass();
            Method method = theClass.getDeclaredMethod(methodName, null);
            return method.invoke(object, (Object[])null);
        }
        catch (Exception e) {
            throw new RuntimeException("Problem calling class method: " + FastExternalUtils.className(object) + "." + methodName, e);
        }
    }

    public static Object executeMethod(Object object, String methodName, Class argumentType, Object argument) {
        try {
            Class<?> theClass = object.getClass();
            Method method = theClass.getDeclaredMethod(methodName, argumentType);
            return method.invoke(object, argument);
        }
        catch (Exception e) {
            throw new RuntimeException("Problem calling class method: " + FastExternalUtils.className(object) + "." + methodName, e);
        }
    }

    public static Throwable getCause(Throwable throwable, String[] methodNames) {
        if (throwable == null) {
            return null;
        }
        Throwable cause = FastExternalUtils.getCauseUsingWellKnownTypes(throwable);
        if (cause == null) {
            String methodName;
            if (methodNames == null) {
                methodNames = CAUSE_METHOD_NAMES;
            }
            for (int i = 0; i < methodNames.length && ((methodName = methodNames[i]) == null || (cause = FastExternalUtils.getCauseUsingMethodName(throwable, methodName)) == null); ++i) {
            }
            if (cause == null) {
                cause = FastExternalUtils.getCauseUsingFieldName(throwable, "detail");
            }
        }
        return cause;
    }

    public static Throwable getRootCause(Throwable throwable) {
        Throwable cause = FastExternalUtils.getCause(throwable);
        if (cause != null) {
            throwable = cause;
            while ((throwable = FastExternalUtils.getCause(throwable)) != null) {
                cause = throwable;
            }
        }
        return cause;
    }

    private static Throwable getCauseUsingWellKnownTypes(Throwable throwable) {
        if (throwable instanceof SQLException) {
            return ((SQLException)throwable).getNextException();
        }
        if (throwable instanceof InvocationTargetException) {
            return ((InvocationTargetException)throwable).getTargetException();
        }
        return null;
    }

    private static Throwable getCauseUsingMethodName(Throwable throwable, String methodName) {
        Method method = null;
        try {
            method = throwable.getClass().getMethod(methodName, null);
        }
        catch (NoSuchMethodException ignored) {
        }
        catch (SecurityException ignored) {
            // empty catch block
        }
        if (method != null && (class$java$lang$Throwable == null ? (class$java$lang$Throwable = FastExternalUtils.class$("java.lang.Throwable")) : class$java$lang$Throwable).isAssignableFrom(method.getReturnType())) {
            try {
                return (Throwable)method.invoke((Object)throwable, new Object[0]);
            }
            catch (IllegalAccessException ignored) {
            }
            catch (IllegalArgumentException ignored) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Throwable getCauseUsingFieldName(Throwable throwable, String fieldName) {
        Field field = null;
        try {
            field = throwable.getClass().getField(fieldName);
        }
        catch (NoSuchFieldException ignored) {
        }
        catch (SecurityException ignored) {
            // empty catch block
        }
        if (field != null && (class$java$lang$Throwable == null ? (class$java$lang$Throwable = FastExternalUtils.class$("java.lang.Throwable")) : class$java$lang$Throwable).isAssignableFrom(field.getType())) {
            try {
                return (Throwable)field.get(throwable);
            }
            catch (IllegalAccessException ignored) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isThrowableNested() {
        return THROWABLE_CAUSE_METHOD != null;
    }

    public static boolean isNestedThrowable(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        if (throwable instanceof SQLException) {
            return true;
        }
        if (throwable instanceof InvocationTargetException) {
            return true;
        }
        if (FastExternalUtils.isThrowableNested()) {
            return true;
        }
        Class<?> cls = throwable.getClass();
        int isize = CAUSE_METHOD_NAMES.length;
        for (int i = 0; i < isize; ++i) {
            try {
                Method method = cls.getMethod(CAUSE_METHOD_NAMES[i], null);
                if (method == null || !(class$java$lang$Throwable == null ? FastExternalUtils.class$("java.lang.Throwable") : class$java$lang$Throwable).isAssignableFrom(method.getReturnType())) continue;
                return true;
            }
            catch (NoSuchMethodException ignored) {
                continue;
            }
            catch (SecurityException ignored) {
                // empty catch block
            }
        }
        try {
            Field field = cls.getField("detail");
            if (field != null) {
                return true;
            }
        }
        catch (NoSuchFieldException ignored) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return false;
    }

    public static int getThrowableCount(Throwable throwable) {
        int count = 0;
        while (throwable != null) {
            ++count;
            throwable = FastExternalUtils.getCause(throwable);
        }
        return count;
    }

    public static Throwable[] getThrowables(Throwable throwable) {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        while (throwable != null) {
            list.add(throwable);
            throwable = FastExternalUtils.getCause(throwable);
        }
        return list.toArray(new Throwable[list.size()]);
    }

    public static int indexOfThrowable(Throwable throwable, Class clazz) {
        return FastExternalUtils.indexOf(throwable, clazz, 0, false);
    }

    public static int indexOfThrowable(Throwable throwable, Class clazz, int fromIndex) {
        return FastExternalUtils.indexOf(throwable, clazz, fromIndex, false);
    }

    public static int indexOfType(Throwable throwable, Class type) {
        return FastExternalUtils.indexOf(throwable, type, 0, true);
    }

    public static int indexOfType(Throwable throwable, Class type, int fromIndex) {
        return FastExternalUtils.indexOf(throwable, type, fromIndex, true);
    }

    private static int indexOf(Throwable throwable, Class type, int fromIndex, boolean subclass) {
        Throwable[] throwables;
        if (throwable == null || type == null) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (fromIndex >= (throwables = FastExternalUtils.getThrowables(throwable)).length) {
            return -1;
        }
        if (subclass) {
            for (int i = fromIndex; i < throwables.length; ++i) {
                if (!type.isAssignableFrom(throwables[i].getClass())) continue;
                return i;
            }
        } else {
            for (int i = fromIndex; i < throwables.length; ++i) {
                if (!type.equals(throwables[i].getClass())) continue;
                return i;
            }
        }
        return -1;
    }

    public static void printRootCauseStackTrace(Throwable throwable) {
        FastExternalUtils.printRootCauseStackTrace(throwable, System.err);
    }

    public static void printRootCauseStackTrace(Throwable throwable, PrintStream stream) {
        if (throwable == null) {
            return;
        }
        if (stream == null) {
            throw new IllegalArgumentException("The PrintStream must not be null");
        }
        String[] trace = FastExternalUtils.getRootCauseStackTrace(throwable);
        for (int i = 0; i < trace.length; ++i) {
            stream.println(trace[i]);
        }
        stream.flush();
    }

    public static void printRootCauseStackTrace(Throwable throwable, PrintWriter writer) {
        if (throwable == null) {
            return;
        }
        if (writer == null) {
            throw new IllegalArgumentException("The PrintWriter must not be null");
        }
        String[] trace = FastExternalUtils.getRootCauseStackTrace(throwable);
        for (int i = 0; i < trace.length; ++i) {
            writer.println(trace[i]);
        }
        writer.flush();
    }

    public static String[] getRootCauseStackTrace(Throwable throwable) {
        if (throwable == null) {
            return new String[0];
        }
        Throwable[] throwables = FastExternalUtils.getThrowables(throwable);
        int count = throwables.length;
        ArrayList<String> frames = new ArrayList<String>();
        List nextTrace = FastExternalUtils.getStackFrameList(throwables[count - 1]);
        int i = count;
        while (--i >= 0) {
            List trace = nextTrace;
            if (i != 0) {
                nextTrace = FastExternalUtils.getStackFrameList(throwables[i - 1]);
                FastExternalUtils.removeCommonFrames(trace, nextTrace);
            }
            if (i == count - 1) {
                frames.add(throwables[i].toString());
            } else {
                frames.add(WRAPPED_MARKER + throwables[i].toString());
            }
            for (int j = 0; j < trace.size(); ++j) {
                frames.add((String)trace.get(j));
            }
        }
        return frames.toArray(new String[0]);
    }

    public static void removeCommonFrames(List causeFrames, List wrapperFrames) {
        if (causeFrames == null || wrapperFrames == null) {
            throw new IllegalArgumentException("The List must not be null");
        }
        int causeFrameIndex = causeFrames.size() - 1;
        for (int wrapperFrameIndex = wrapperFrames.size() - 1; causeFrameIndex >= 0 && wrapperFrameIndex >= 0; --causeFrameIndex, --wrapperFrameIndex) {
            String wrapperFrame;
            String causeFrame = (String)causeFrames.get(causeFrameIndex);
            if (!causeFrame.equals(wrapperFrame = (String)wrapperFrames.get(wrapperFrameIndex))) continue;
            causeFrames.remove(causeFrameIndex);
        }
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    public static String getFullStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        Throwable[] ts = FastExternalUtils.getThrowables(throwable);
        for (int i = 0; i < ts.length; ++i) {
            ts[i].printStackTrace(pw);
            if (FastExternalUtils.isNestedThrowable(ts[i])) break;
        }
        return sw.getBuffer().toString();
    }

    public static String[] getStackFrames(Throwable throwable) {
        if (throwable == null) {
            return new String[0];
        }
        return FastExternalUtils.getStackFrames(FastExternalUtils.getStackTrace(throwable));
    }

    public static String[] getStackFrames(String stackTrace) {
        String linebreak = FastExternalUtils.getSystemProperty("line.separator");
        StringTokenizer frames = new StringTokenizer(stackTrace, linebreak);
        LinkedList<String> list = new LinkedList<String>();
        while (frames.hasMoreTokens()) {
            list.add(frames.nextToken());
        }
        return FastExternalUtils.toArray(list);
    }

    public static List getStackFrameList(Throwable t) {
        String stackTrace = FastExternalUtils.getStackTrace(t);
        String linebreak = FastExternalUtils.getSystemProperty("line.separator");
        StringTokenizer frames = new StringTokenizer(stackTrace, linebreak);
        LinkedList<String> list = new LinkedList<String>();
        boolean traceStarted = false;
        while (frames.hasMoreTokens()) {
            String token = frames.nextToken();
            int at = token.indexOf("at");
            if (at != -1 && token.substring(0, at).trim().length() == 0) {
                traceStarted = true;
                list.add(token);
                continue;
            }
            if (!traceStarted) continue;
            break;
        }
        return list;
    }

    private static String getSystemProperty(String property) {
        try {
            return System.getProperty(property);
        }
        catch (SecurityException ex) {
            System.err.println("Caught a SecurityException reading the system property '" + property + "'; the SystemUtils property value will default to null.");
            return null;
        }
    }

    public static boolean isNotEmpty(String str) {
        return str != null && str.length() > 0;
    }

    public static int indexOf(Object[] array, Object objectToFind) {
        return FastExternalUtils.indexOf(array, objectToFind, 0);
    }

    public static int indexOf(Object[] array, Object objectToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (objectToFind == null) {
            for (int i = startIndex; i < array.length; ++i) {
                if (array[i] != null) continue;
                return i;
            }
        } else {
            for (int i = startIndex; i < array.length; ++i) {
                if (!objectToFind.equals(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean equals(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equals(str2);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Method getCauseMethod;
        CAUSE_METHOD_NAMES = new String[]{"getCause", "getNextException", "getTargetException", "getException", "getSourceException", "getRootCause", "getCausedByException", "getNested", "getLinkedException", "getNestedException", "getLinkedCause", "getThrowable"};
        try {
            getCauseMethod = (class$java$lang$Throwable == null ? (class$java$lang$Throwable = FastExternalUtils.class$("java.lang.Throwable")) : class$java$lang$Throwable).getMethod("getCause", null);
        }
        catch (Exception e) {
            getCauseMethod = null;
        }
        THROWABLE_CAUSE_METHOD = getCauseMethod;
    }
}

