/*
 * Decompiled with CFR 0.152.
 */
package edu.upenn.isc.fast.log;

import edu.upenn.isc.fast.log.FastLoggerExternal;
import edu.upenn.isc.fast.util.FastExternalUtils;
import java.io.BufferedWriter;
import java.util.Date;
import java.util.Enumeration;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class FastLoggerExternalJ2ee {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void logServletRequest(FastLoggerExternal logger, Object object, boolean requireVerbose) {
        if (logger.shouldWriteToLog(requireVerbose)) {
            HttpServletRequest request = null;
            BufferedWriter fileWriter = null;
            try {
                String name;
                fileWriter = logger.writer();
                if (object == null) {
                    fileWriter.write("request is null");
                    return;
                }
                if (!(object instanceof HttpServletRequest)) {
                    fileWriter.write("Object not httpservletrequest: " + FastExternalUtils.className(object));
                    return;
                }
                request = (HttpServletRequest)object;
                fileWriter.write("request: ");
                fileWriter.write(" headers: ");
                Enumeration enumeration = request.getHeaderNames();
                while (enumeration.hasMoreElements()) {
                    name = (String)enumeration.nextElement();
                    fileWriter.write("(" + name + "=" + request.getHeader(name) + ")");
                }
                fileWriter.write("\n- parameters: ");
                enumeration = request.getParameterNames();
                while (enumeration.hasMoreElements()) {
                    name = (String)enumeration.nextElement();
                    fileWriter.write("(" + name + "=" + request.getParameter(name) + ")");
                }
                fileWriter.write("\n- attributes: ");
                enumeration = request.getAttributeNames();
                while (enumeration.hasMoreElements()) {
                    name = (String)enumeration.nextElement();
                    fileWriter.write("(" + name + "=" + request.getAttribute(name) + ")");
                }
                fileWriter.write("\n- cookies: ");
                Cookie[] cookies = request.getCookies();
                for (int i = 0; cookies != null && i < cookies.length; ++i) {
                    fileWriter.write("(name: " + cookies[i].getName() + ", value: " + cookies[i].getValue() + ", domain: " + cookies[i].getDomain() + ", path: " + cookies[i].getPath() + ") ");
                }
                fileWriter.write("\n- requestURL is: " + request.getRequestURL());
                fileWriter.write("\n- method is: " + request.getMethod());
                fileWriter.write("\n- queryString is: " + request.getQueryString());
                fileWriter.write("\n- userPrincipal is: " + request.getUserPrincipal());
                fileWriter.write("\n- remoteUser is: " + request.getRemoteUser());
                fileWriter.write("\n- remoteHost is: " + request.getRemoteHost());
                fileWriter.write("\n- remoteAddr is: " + request.getRemoteAddr());
                fileWriter.write("\n- serverName is: " + request.getServerName());
                fileWriter.write("\n- serverPort is: " + request.getServerPort());
            }
            catch (Exception e) {
                try {
                    fileWriter.write("Error writing J2ee request" + FastExternalUtils.getFullStackTrace(e));
                }
                catch (Exception e2) {
                    throw new RuntimeException("Error writing request to log: " + logger, e);
                }
            }
            finally {
                logger.endLogEntry(fileWriter);
            }
            HttpSession session = request.getSession(false);
            FastLoggerExternalJ2ee.logServletSession(logger, session, requireVerbose);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void logServletSession(FastLoggerExternal logger, Object object, boolean requireVerbose) {
        if (logger.shouldWriteToLog(requireVerbose)) {
            BufferedWriter fileWriter = null;
            try {
                fileWriter = logger.writer();
                if (object == null) {
                    fileWriter.write("session is null");
                    return;
                }
                if (!(object instanceof HttpSession)) {
                    fileWriter.write("Object not httpsession: " + FastExternalUtils.className(object));
                    return;
                }
                HttpSession session = (HttpSession)object;
                fileWriter.write("session: ");
                fileWriter.write(" attributes: ");
                Enumeration enumeration = session.getAttributeNames();
                while (enumeration.hasMoreElements()) {
                    String name = (String)enumeration.nextElement();
                    fileWriter.write("(" + name + "=" + session.getAttribute(name) + ")");
                }
                fileWriter.write("\n- creationTime is: " + new Date(session.getCreationTime()));
                fileWriter.write("\n- lastAccessed is: " + new Date(session.getLastAccessedTime()));
                fileWriter.write("\n- maxInactive is: " + session.getMaxInactiveInterval() + " seconds");
            }
            catch (Exception e) {
                try {
                    fileWriter.write("Error writing J2ee session" + FastExternalUtils.getFullStackTrace(e));
                }
                catch (Exception e2) {
                    throw new RuntimeException("Error writing session to log: " + logger, e);
                }
            }
            finally {
                logger.endLogEntry(fileWriter);
            }
        }
    }
}

