/*
 * Decompiled with CFR 0.152.
 */
package edu.upenn.isc.fast.log;

import edu.upenn.isc.fast.log.FastLoggerExternalJ2ee;
import edu.upenn.isc.fast.util.FastExternalUtils;
import edu.upenn.isc.fast.util.FastPropertyFileUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;

public class FastLoggerExternal {
    private File logFile = null;
    private String propertiesFileLocation = null;
    private String verbosePropertyName = null;

    public FastLoggerExternal(String logFileLocationPropertyName, String thePropertiesFileLocation, String theVerbosePropertyName) {
        String logFileLocation = FastPropertyFileUtils.retrievePropertyString(thePropertiesFileLocation, logFileLocationPropertyName);
        File theLogFile = new File(logFileLocation);
        this.constructorHelper(theLogFile, thePropertiesFileLocation, theVerbosePropertyName);
    }

    public FastLoggerExternal(File theLogFile, String thePropertiesFileLocation, String theVerbosePropertyName) {
        this.constructorHelper(theLogFile, thePropertiesFileLocation, theVerbosePropertyName);
    }

    public boolean verbose() {
        return FastPropertyFileUtils.retrievePropertyBoolean(this.propertiesFileLocation, this.verbosePropertyName);
    }

    void constructorHelper(File theLogFile, String thePropertiesFileLocation, String theVerbosePropertyName) {
        this.logFile = theLogFile;
        this.propertiesFileLocation = thePropertiesFileLocation;
        this.verbosePropertyName = theVerbosePropertyName;
        FastExternalUtils.initFile(this.logFile);
    }

    public String toString() {
        return "Logger: logFile: " + (this.logFile == null ? null : this.logFile.getAbsolutePath()) + ", props loc: " + this.propertiesFileLocation + ", verbose prop: " + this.verbosePropertyName;
    }

    BufferedWriter writer() throws IOException {
        FastExternalUtils.initFile(this.logFile);
        BufferedWriter fileWriter = new BufferedWriter(new FileWriter(this.logFile, true));
        fileWriter.write(new Date().toString());
        fileWriter.write(": ");
        return fileWriter;
    }

    boolean shouldWriteToLog(boolean requireVerbose) {
        boolean verbose = this.verbose();
        return !requireVerbose || verbose;
    }

    public synchronized void log(String message, boolean requireVerbose) {
        if (this.shouldWriteToLog(requireVerbose)) {
            BufferedWriter fileWriter = null;
            try {
                fileWriter = this.writer();
                fileWriter.write(message);
            }
            catch (Exception e) {
                String stack = FastExternalUtils.getFullStackTrace(e);
                String exceptionMessage = "Error writing to log: " + this + ", " + message + ", " + stack;
                throw new RuntimeException(exceptionMessage, e);
            }
            finally {
                this.endLogEntry(fileWriter);
            }
        }
    }

    public synchronized void log(Exception exception, boolean requireVerbose) {
        if (this.shouldWriteToLog(requireVerbose)) {
            BufferedWriter fileWriter = null;
            try {
                fileWriter = this.writer();
                fileWriter.write(FastExternalUtils.getFullStackTrace(exception));
            }
            catch (Exception e) {
                throw new RuntimeException("Error writing to log: " + this);
            }
            finally {
                this.endLogEntry(fileWriter);
            }
        }
    }

    public synchronized void logServletRequest(Object request, boolean requireVerbose) {
        FastLoggerExternalJ2ee.logServletRequest(this, request, requireVerbose);
    }

    void endLogEntry(BufferedWriter fileWriter) {
        try {
            fileWriter.write("\n\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
        FastExternalUtils.closeQuietly(fileWriter);
    }
}

