/*
 * Decompiled with CFR 0.152.
 */
package edu.yale.its.tp.cas.client.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class SimpleCASAuthorizationFilter
implements Filter {
    public static final String AUTHORIZED_USER_STRING = "edu.yale.its.tp.cas.client.filter.authorizedUsers";
    public static final String FILTER_NAME = "SimpleCASAuthorizationFilter";
    private String authorizedUsersString;
    private List authorizedUsers;

    public void init(FilterConfig config) throws ServletException {
        this.authorizedUsersString = config.getInitParameter(AUTHORIZED_USER_STRING);
        StringTokenizer tokenizer = new StringTokenizer(this.authorizedUsersString);
        this.authorizedUsers = new ArrayList();
        while (tokenizer.hasMoreTokens()) {
            this.authorizedUsers.add(tokenizer.nextElement());
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain fc) throws ServletException, IOException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            throw new ServletException("SimpleCASAuthorizationFilter: protects only HTTP resources");
        }
        HttpSession session = ((HttpServletRequest)request).getSession();
        if (this.authorizedUsers.isEmpty()) {
            throw new ServletException("SimpleCASAuthorizationFilter: no authorized users set.");
        }
        if (!this.authorizedUsers.contains((String)session.getAttribute("edu.yale.its.tp.cas.client.filter.user"))) {
            throw new ServletException("SimpleCASAuthorizationFilter: user " + session.getAttribute("edu.yale.its.tp.cas.client.filter.user") + " not authorized.");
        }
        fc.doFilter(request, response);
    }

    public void destroy() {
    }
}

