/*
 * Copyright 2010 University Corporation for Advanced Internet Development, Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this
 * file except in compliance with the License. You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package edu.internet2.middleware.ldappc.spml;

/**
 * Constants, probably subject to substantial change.
 */
public class PSPConstants {

  public static final String ERROR_INVALID_ATTRIBUTE = "Invalid attribute.";

  public static final String ERROR_INVALID_ENTITY_NAME = "Invalid entity name.";

  public static final String ERROR_NO_DATA = "Data is required.";

  public static final String ERROR_NO_OBJECT_IDENTIFIER = "Unable to calculate provisioned object.";

  public static final String ERROR_NULL_ID = "An id is required.";

  public static final String ERROR_NULL_MODIFICATION_MODE = "A modification mode is required.";

  public static final String ERROR_NULL_MODIFICATIONS = "A modification is required.";

  public static final String ERROR_NULL_PSO_ID = "A psoID is required.";

  public static final String ERROR_NULL_QUERY = "A query is required.";

  public static final String ERROR_NULL_STATUS = "A status code is required.";

  public static final String ERROR_NULL_TARGET_ID = "A targetID is required.";

  public static final String ERROR_UNSUPPORTED_MODIFICATION_MODE = "Unsupported modification mode.";

  public static final String ERROR_UNSUPPORTED_STATUS = "Unsupported status code.";

  public static final String MDC_REQUESTID = "requestID";
}
