/*
 * Decompiled with CFR 0.152.
 */
package org.openspml.v2.util.xml;

import java.io.IOException;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.openspml.v2.util.Spml2Exception;
import org.openspml.v2.util.xml.XmlParser;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlUtil {
    public static String serializeNode(Node node) throws Spml2Exception {
        String serialization = null;
        StringWriter writer = null;
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource input = new DOMSource(node);
            writer = new StringWriter();
            StreamResult output = new StreamResult(writer);
            transformer.setOutputProperty("method", "xml");
            if (node.getNodeType() == 9) {
                DocumentType doctype = ((Document)node).getDoctype();
                String publicId = null;
                String systemId = null;
                if (doctype != null) {
                    publicId = doctype.getPublicId();
                    systemId = doctype.getSystemId();
                }
                if (systemId != null) {
                    transformer.setOutputProperty("doctype-system", systemId);
                    if (publicId != null) {
                        transformer.setOutputProperty("doctype-public", publicId);
                    }
                }
            }
            transformer.transform(input, output);
            String string = serialization = writer.toString();
            return string;
        }
        catch (TransformerConfigurationException ex) {
            throw new Spml2Exception(ex);
        }
        catch (TransformerException ex) {
            throw new Spml2Exception(ex);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    public static String makeXmlFragmentFromDoc(String xml) {
        String toRemove = "\\<\\?xml version=\"1.0\" encoding=\"UTF-8\"\\?\\>\n";
        StringBuffer buffer = new StringBuffer();
        String[] pieces = xml.split(toRemove);
        for (int k = 0; k < pieces.length; ++k) {
            buffer.append(pieces[k]);
        }
        return buffer.toString();
    }

    public static Element getFirstChildElement(Node node) {
        Element firstChildElement = null;
        if (node != null) {
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 1) continue;
                firstChildElement = (Element)child;
                break;
            }
        }
        return firstChildElement;
    }

    public static String getSoapBodyContents(String message) throws Spml2Exception {
        Document doc = XmlParser.parse(message);
        NodeList list = doc.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Body");
        Node node = list.item(0);
        node = XmlUtil.getFirstChildElement(node);
        return XmlUtil.serializeNode(node);
    }
}

