/*
 * Decompiled with CFR 0.152.
 */
package org.openspml.v2.util.xml;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class XmlBuffer {
    private static final String code_id = "$Id: XmlBuffer.java,v 1.2 2006/10/18 16:57:36 kas Exp $";
    public static final String XML_HEADER = "<?xml version='1.0' encoding='UTF-8'?>";
    private StringBuffer _buf;
    private int _indent;
    private String _prefix;
    private URI _namespace;
    private boolean _namespaceDeclared;
    private Map _namespaces;

    public XmlBuffer() {
        this._buf = new StringBuffer();
    }

    public XmlBuffer(int length) {
        this._buf = new StringBuffer(length);
    }

    public int getIndent() {
        return this._indent;
    }

    public void setIndent(int indent) {
        this._indent = indent;
    }

    public void setPrefix(String s) {
        this._prefix = s;
    }

    public void setNamespace(URI uri) {
        this._namespace = uri;
    }

    public void addNamespace(String name, URI uri) {
        if (name != null && uri != null) {
            if (this._namespaces == null) {
                this._namespaces = new HashMap();
            }
            this._namespaces.put(name, uri);
        }
    }

    public void append(String s) {
        this._buf.append(s);
    }

    public void append(Integer i) {
        this._buf.append(i);
    }

    public void append(char c) {
        this._buf.append(c);
    }

    public void append(int i) {
        this._buf.append(i);
    }

    public char charAt(int index) {
        return this._buf.charAt(index);
    }

    public String toString() {
        return this._buf.toString();
    }

    public int length() {
        return this._buf.length();
    }

    public void setLength(int len) {
        this._buf.setLength(len);
        this._namespaceDeclared = false;
    }

    public void incIndent(int i) {
        this._indent += i;
    }

    public void incIndent() {
        this._indent += 2;
    }

    public void decIndent(int i) {
        this._indent -= i;
        if (this._indent < 0) {
            this._indent = 0;
        }
    }

    public void decIndent() {
        this._indent -= 2;
        if (this._indent < 0) {
            this._indent = 0;
        }
    }

    public void addAttribute(String name, String prefix, String value) {
        if (value != null && value.length() > 0) {
            char ch;
            int i;
            this.append(" ");
            if (prefix != null) {
                this.append(prefix);
                this.append(":");
            }
            this.append(name);
            this.append("=");
            int doubles = 0;
            int singles = 0;
            char delim = '\'';
            int max = value.length();
            for (i = 0; i < max; ++i) {
                ch = value.charAt(i);
                if (ch == '\"') {
                    ++doubles;
                    continue;
                }
                if (ch != '\'') continue;
                ++singles;
            }
            if (singles > 0) {
                delim = '\"';
            }
            this.append(delim);
            for (i = 0; i < max; ++i) {
                ch = value.charAt(i);
                if (ch == '&') {
                    this.append("&amp;");
                    continue;
                }
                if (ch == '<') {
                    this.append("&lt;");
                    continue;
                }
                if (ch < ' ') continue;
                if (ch != delim) {
                    this.append(ch);
                    continue;
                }
                if (delim == '\'') {
                    this.append("&#39;");
                    continue;
                }
                this.append("&#34;");
            }
            this.append(delim);
        }
    }

    public void addAttribute(String name, String value) {
        this.addAttribute(name, null, value);
    }

    public void addAttribute(String name, Object obj) {
        if (obj != null) {
            this.addAttribute(name, obj.toString());
        }
    }

    public void addAttribute(String name, boolean value) {
        if (value) {
            this.append(" ");
            this.append(name);
            this.append("='true'");
        }
    }

    public void addAttribute(String name, int value) {
        this._buf.append(" ");
        this._buf.append(name);
        this._buf.append("='");
        this._buf.append(value);
        this._buf.append("'");
    }

    public void addContent(String s) {
        if (s != null) {
            int max = s.length();
            for (int i = 0; i < max; ++i) {
                char ch = s.charAt(i);
                if (ch == '&') {
                    this._buf.append("&amp;");
                    continue;
                }
                if (ch == '<') {
                    this._buf.append("&lt;");
                    continue;
                }
                this._buf.append(ch);
            }
        }
    }

    public void addIndent(int indent) {
        if (indent > 0) {
            for (int i = 0; i < indent; ++i) {
                this._buf.append(" ");
            }
        }
    }

    public void addOpenStartTag(String name) {
        this.addOpenStartTag(this._prefix, name);
    }

    public void addOpenStartTag(String prefix, String name) {
        this.addIndent(this._indent);
        this.append("<");
        if (prefix != null && name.indexOf(":") < 0) {
            this.append(prefix);
            this.append(":");
        }
        this.append(name);
        this.checkNamespace();
    }

    public void addOpenStartTagNS(String urn, String name) {
        this.addIndent(this._indent);
        this.append("<");
        this.append(name);
        this.append(" xmlns='");
        this.append(urn);
        this.append("'");
    }

    private void checkNamespace() {
        if (!this._namespaceDeclared) {
            if (this._namespace != null) {
                this.append(" xmlns");
                if (this._prefix != null) {
                    this.append(":");
                    this.append(this._prefix);
                }
                this.append("='");
                this.append(this._namespace.toString());
                this.append("'");
            }
            if (this._namespaces != null) {
                for (Map.Entry entry : this._namespaces.entrySet()) {
                    this.append(" xmlns:");
                    this.append(entry.getKey().toString());
                    this.append("='");
                    this.append(entry.getValue().toString());
                    this.append("'");
                }
            }
            this._namespaceDeclared = true;
        }
    }

    public void closeStartTag() {
        this.closeStartTag(true);
    }

    public void closeStartTag(boolean newline) {
        this.append(">");
        if (newline) {
            this.append("\n");
        }
    }

    public void closeEmptyElement() {
        this.append("/>\n");
    }

    public void addStartTag(String name) {
        this.addStartTag(this._prefix, name, true);
    }

    public void addStartTag(String prefix, String name) {
        this.addStartTag(prefix, name, true);
    }

    public void addStartTagNS(String urn, String name, boolean newline) {
        this.addIndent(this._indent);
        this.append("<");
        this.append(name);
        this.append(" xmlns='");
        this.append(urn);
        this.append("'>");
        if (newline) {
            this.append("\n");
        }
    }

    public void addStartTag(String name, boolean newline) {
        this.addStartTag(this._prefix, name, newline);
    }

    public void addStartTag(String prefix, String name, boolean newline) {
        this.addIndent(this._indent);
        this.append("<");
        if (prefix != null && name.indexOf(":") < 0) {
            this.append(prefix);
            this.append(":");
        }
        this.append(name);
        this.checkNamespace();
        this.append(">");
        if (newline) {
            this.append("\n");
        }
    }

    public void addEndTag(String name) {
        this.addEndTag(this._prefix, name);
    }

    public void addEndTag(String prefix, String name) {
        this.addEndTag(prefix, name, true);
    }

    public void addEndTag(String name, boolean indent) {
        this.addEndTag(this._prefix, name, indent);
    }

    public void addEndTag(String prefix, String name, boolean indent) {
        if (indent) {
            this.addIndent(this._indent);
        }
        this.append("</");
        if (prefix != null && name.indexOf(":") < 0) {
            this.append(prefix);
            this.append(":");
        }
        this.append(name);
        this.append(">\n");
    }

    public void addElement(String element, String content) {
        this.addElement(this._prefix, element, content);
    }

    public void addElement(String prefix, String element, String content) {
        if (content != null) {
            this.addStartTag(prefix, element, false);
            this.addContent(content);
            this.addEndTag(prefix, element, false);
        }
    }

    public void addAnyElement(String xml) {
        this.addAnyElement(xml, false);
    }

    public void addAnyElement(String xml, boolean noIndent) {
        if (!noIndent) {
            this.addIndent(this._indent);
        }
        this.append(xml);
    }
}

