/*
 * Decompiled with CFR 0.152.
 */
package org.openspml.v2.util.xml;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.openspml.v2.msg.Marshallable;
import org.openspml.v2.msg.MarshallableElement;
import org.openspml.v2.msg.OpenContentAttr;
import org.openspml.v2.msg.OpenContentContainer;
import org.openspml.v2.msg.OpenContentElement;
import org.openspml.v2.msg.PrefixAndNamespaceTuple;
import org.openspml.v2.msg.XMLMarshaller;
import org.openspml.v2.msg.spml.Selection;
import org.openspml.v2.util.Spml2Exception;
import org.openspml.v2.util.xml.ListWithType;
import org.openspml.v2.util.xml.ReflectionUtilities;
import org.openspml.v2.util.xml.XmlBuffer;

public class ReflectiveXMLMarshaller
implements XMLMarshaller {
    private static final String code_id = "$Id: ReflectiveXMLMarshaller.java,v 1.12 2006/10/04 01:06:12 kas Exp $";
    private ThreadLocal mBuffer = new ThreadLocal();
    private int mIndent = 0;

    protected String marshall(String elementName, Marshallable obj) throws Spml2Exception {
        return this.marshall(elementName, obj, this.mIndent);
    }

    protected String marshall(String elementName, Marshallable m, int indent) throws Spml2Exception {
        try {
            PrefixAndNamespaceTuple[] tuples;
            if (elementName == null) {
                elementName = m.getElementName();
            }
            this.mBuffer.set(new XmlBuffer());
            if (indent != 0) {
                ((XmlBuffer)this.mBuffer.get()).setIndent(indent);
            }
            if ((tuples = m.getNamespacesInfo()) != null) {
                for (int k = 0; k < tuples.length; ++k) {
                    PrefixAndNamespaceTuple tuple = tuples[k];
                    URI ns = new URI(tuple.namespaceURI);
                    if (tuple.isDefault) {
                        ((XmlBuffer)this.mBuffer.get()).setNamespace(ns);
                        continue;
                    }
                    ((XmlBuffer)this.mBuffer.get()).addNamespace(tuple.prefix, ns);
                }
            }
            this.redispatch(m, elementName);
            return ((XmlBuffer)this.mBuffer.get()).toString();
        }
        catch (URISyntaxException e) {
            throw new Spml2Exception(e);
        }
    }

    private void redispatch(MarshallableElement obj, String elname) throws Spml2Exception {
        try {
            Method method = this.getClass().getDeclaredMethod("marshall", obj.getClass(), String.class);
            method.invoke((Object)this, obj, elname);
        }
        catch (NoSuchMethodException e) {
            this.default_marshall(obj, elname);
        }
        catch (IllegalAccessException e) {
            throw new Spml2Exception(e);
        }
        catch (InvocationTargetException e) {
            System.out.println("elname is " + elname);
            System.out.println("partial buffer:\n" + (XmlBuffer)this.mBuffer.get());
            e.getCause().printStackTrace(System.err);
            throw new Spml2Exception(e);
        }
    }

    private Field[] processAttributeFields(MarshallableElement me, String elName) throws Spml2Exception {
        String prefix = this.getPreferredPrefix(me);
        ((XmlBuffer)this.mBuffer.get()).addOpenStartTag(prefix, elName);
        if (me instanceof OpenContentContainer) {
            OpenContentAttr[] attrs = ((OpenContentContainer)((Object)me)).getOpenContentAttrs();
            this.addOpenContentAttrs(attrs);
        }
        ArrayList attributes = new ArrayList();
        ArrayList nonAttributeFields = new ArrayList();
        ReflectionUtilities.getAttributeAndElementFields(me, attributes, nonAttributeFields);
        for (int k = 0; k < attributes.size(); ++k) {
            Field field = (Field)attributes.get(k);
            String attrPrefix = null;
            this.addAttributeForField(me, attrPrefix, field);
        }
        return nonAttributeFields.toArray(new Field[nonAttributeFields.size()]);
    }

    private void addOpenContentAttrs(OpenContentAttr[] attrs) {
        for (int k = 0; k < attrs.length; ++k) {
            OpenContentAttr attr = attrs[k];
            if (attr == null) continue;
            String name = attr.getName();
            String value = attr.getValue();
            if (name == null || value == null) continue;
            ((XmlBuffer)this.mBuffer.get()).addAttribute(name, value);
        }
    }

    private void addAttributeForField(MarshallableElement mar, String prefix, Field field) {
        try {
            String attrName = ReflectionUtilities.getAttributeNameFromField(field);
            field.setAccessible(true);
            Object val = field.get(mar);
            if (val != null) {
                ((XmlBuffer)this.mBuffer.get()).addAttribute(attrName, prefix, val.toString());
            }
        }
        catch (IllegalAccessException e) {
            // empty catch block
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processElementFields(MarshallableElement me, Field[] fields, String name) throws Spml2Exception {
        tagClosed = false;
        if (me instanceof OpenContentContainer && (els = ((OpenContentContainer)me).getOpenContentElements()) != null && els.length != 0) {
            ((XmlBuffer)this.mBuffer.get()).closeStartTag();
            tagClosed = true;
            this.addOpenContentElements(els);
        }
lbl7:
        // 5 sources

        try {
            for (k = 0; k < fields.length; ++k) {
                block18: {
                    block17: {
                        field = fields[k];
                        fType = field.getType();
                        elname = ReflectionUtilities.getElementNameFromField(field);
                        field.setAccessible(true);
                        if (MarshallableElement.class.isAssignableFrom(fType)) {
                            fVal = (MarshallableElement)field.get(me);
                            if (fVal == null) continue;
                            if (!tagClosed) {
                                ((XmlBuffer)this.mBuffer.get()).closeStartTag();
                                tagClosed = true;
                            }
                            ((XmlBuffer)this.mBuffer.get()).incIndent();
                            prefix = this.getMarshallableElementPrefix(me);
                            if (fVal instanceof Marshallable) {
                                prefix = "";
                            }
                            this.redispatch(fVal, prefix + elname);
                            ((XmlBuffer)this.mBuffer.get()).decIndent();
                            continue;
                        }
                        if (ListWithType.class.isAssignableFrom(fType)) {
                            c = (ListWithType)field.get(me);
                            if (c.isEmpty()) continue;
                            ((XmlBuffer)this.mBuffer.get()).incIndent();
                            iter = c.iterator();
                            while (iter.hasNext()) {
                                if (!tagClosed) {
                                    ((XmlBuffer)this.mBuffer.get()).closeStartTag();
                                    tagClosed = true;
                                }
                                prefix = this.getMarshallableElementPrefix(me);
                                val = iter.next();
                                if (val instanceof Marshallable) {
                                    marVal = (Marshallable)val;
                                    elname = marVal.getElementName();
                                    prefix = "";
                                }
                                this.redispatch((MarshallableElement)val, prefix + elname);
                            }
                            ((XmlBuffer)this.mBuffer.get()).decIndent();
                            continue;
                        }
                        if (!List.class.isAssignableFrom(fType)) break block17;
                        list = (List)field.get(me);
                        for (v = 0; v < list.size(); ++v) {
                            if (!tagClosed) {
                                ((XmlBuffer)this.mBuffer.get()).closeStartTag();
                                tagClosed = true;
                            }
                            val = list.get(v);
                            ((XmlBuffer)this.mBuffer.get()).incIndent();
                            ((XmlBuffer)this.mBuffer.get()).addElement(elname, val.toString());
                            ((XmlBuffer)this.mBuffer.get()).decIndent();
                        }
                        ** GOTO lbl7
                    }
                    if (!fType.isArray() || !String.class.equals(fType.getComponentType())) break block18;
                    array = (String[])field.get(me);
                    prefix = this.getPreferredPrefix(me);
                    for (j = 0; array != null && j < array.length; ++j) {
                        if (!tagClosed) {
                            ((XmlBuffer)this.mBuffer.get()).closeStartTag();
                            tagClosed = true;
                        }
                        ((XmlBuffer)this.mBuffer.get()).incIndent();
                        ((XmlBuffer)this.mBuffer.get()).addElement(prefix, elname, array[j]);
                        ((XmlBuffer)this.mBuffer.get()).decIndent();
                    }
                    ** GOTO lbl7
                }
                System.out.println("field not handled: " + field.getName() + ":" + field.getType());
            }
        }
        catch (IllegalAccessException e) {
            throw new Spml2Exception(e);
        }
        if (!tagClosed) {
            ((XmlBuffer)this.mBuffer.get()).closeEmptyElement();
        } else {
            prefix = this.getPreferredPrefix(me);
            ((XmlBuffer)this.mBuffer.get()).addEndTag(prefix, name);
        }
    }

    private String getPreferredPrefix(MarshallableElement me) throws Spml2Exception {
        return ReflectionUtilities.getPreferredPrefix(me);
    }

    private String getMarshallableElementPrefix(MarshallableElement me) throws Spml2Exception {
        String prefix = this.getPreferredPrefix(me);
        prefix = prefix != null ? prefix + ":" : "";
        return prefix;
    }

    private boolean addOpenContentElements(OpenContentElement[] els) throws Spml2Exception {
        if (els.length > 0) {
            ((XmlBuffer)this.mBuffer.get()).incIndent();
            for (int k = 0; k < els.length; ++k) {
                int indent = ((XmlBuffer)this.mBuffer.get()).getIndent();
                ((XmlBuffer)this.mBuffer.get()).addAnyElement(els[k].toXML(indent), true);
            }
            ((XmlBuffer)this.mBuffer.get()).decIndent();
            return true;
        }
        return false;
    }

    protected void default_marshall(MarshallableElement e, String elName) throws Spml2Exception {
        Field[] els = this.processAttributeFields(e, elName);
        this.processElementFields(e, els, elName);
    }

    protected String marshall(Selection s, String element) throws Spml2Exception {
        this.default_marshall(s, "select");
        return ((XmlBuffer)this.mBuffer.get()).toString();
    }

    public ReflectiveXMLMarshaller() {
    }

    public ReflectiveXMLMarshaller(int indent) throws Spml2Exception {
        this.setIndent(indent);
    }

    public void setIndent(int indent) throws Spml2Exception {
        if (indent >= 0) {
            this.mIndent = indent;
        }
    }

    public String marshall(Marshallable m) throws Spml2Exception {
        return this.marshall(null, m);
    }
}

