/*
 * Decompiled with CFR 0.152.
 */
package org.openspml.v2.util.xml;

import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openspml.v2.msg.Marshallable;
import org.openspml.v2.msg.MarshallableElement;
import org.openspml.v2.msg.OCEtoMarshallableAdapter;
import org.openspml.v2.msg.OpenContentContainer;
import org.openspml.v2.msg.OpenContentElement;
import org.openspml.v2.msg.XMLUnmarshaller;
import org.openspml.v2.util.BasicStringEnumConstant;
import org.openspml.v2.util.EnumConstant;
import org.openspml.v2.util.Spml2Exception;
import org.openspml.v2.util.xml.ListWithType;
import org.openspml.v2.util.xml.ObjectFactory;
import org.openspml.v2.util.xml.ReflectionUtilities;
import org.openspml.v2.util.xml.UnknownSpml2TypeException;
import org.openspml.v2.util.xml.XmlParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ReflectiveDOMXMLUnmarshaller
implements XMLUnmarshaller {
    private static final String code_id = "$Id: ReflectiveDOMXMLUnmarshaller.java,v 1.19 2006/08/30 18:02:59 kas Exp $";
    private static OCEUnmarshallerForMarshallables m4Marshallables;

    protected Marshallable createAndPopulateMarshallable(String typeName, Element el) throws Spml2Exception {
        String nsURI = el.getNamespaceURI();
        Marshallable m = ObjectFactory.getInstance().createMarshallable(typeName, nsURI);
        this.populate(m, el);
        return m;
    }

    private void populate(MarshallableElement ext, Element element) throws Spml2Exception {
        ArrayList attrFields = new ArrayList();
        ArrayList elementFields = new ArrayList();
        ReflectionUtilities.getAttributeAndElementFields(ext, attrFields, elementFields);
        this.populateAttributes(ext, attrFields, element);
        this.populateElements(ext, elementFields, element);
    }

    private void populateAttributes(MarshallableElement ext, List attrFields, Element element) throws Spml2Exception {
        try {
            HashSet<String> knownAttrs = new HashSet<String>();
            for (int k = 0; k < attrFields.size(); ++k) {
                Field field = (Field)attrFields.get(k);
                String attrName = ReflectionUtilities.getAttributeNameFromField(field);
                knownAttrs.add(attrName);
                String value = element.getAttribute(attrName);
                if (this.valueIsEmpty(value)) continue;
                field.setAccessible(true);
                Class<?> fType = field.getType();
                if (BasicStringEnumConstant.class.isAssignableFrom(fType)) {
                    EnumConstant ec = BasicStringEnumConstant.getConstant(fType, value.toString());
                    if (ec == null) continue;
                    field.set(ext, ec);
                    continue;
                }
                if (fType == String.class) {
                    field.set(ext, value);
                    continue;
                }
                if (fType == URI.class) {
                    try {
                        field.set(ext, new URI(value.toString()));
                        continue;
                    }
                    catch (URISyntaxException e) {
                        throw new Spml2Exception("Bad URI format for field " + field, e);
                    }
                }
                if (fType == Boolean.class || fType == Boolean.TYPE) {
                    field.set(ext, new Boolean(value.toString()));
                    continue;
                }
                if (fType != Integer.class && fType != Integer.TYPE) continue;
                field.set(ext, new Integer(value.toString()));
            }
            NamedNodeMap nnm = element.getAttributes();
            int numAttrs = nnm.getLength();
            for (int k = 0; k < numAttrs; ++k) {
                Node attr = nnm.item(k);
                String name = attr.getNodeName();
                if (name.startsWith("xmlns") || knownAttrs.contains(name) || !(ext instanceof OpenContentContainer)) continue;
                ((OpenContentContainer)((Object)ext)).addOpenContentAttr(name, attr.getNodeValue());
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new Spml2Exception(e);
        }
    }

    private boolean valueIsEmpty(Object value) {
        return value == null || value.toString().length() == 0;
    }

    private void populateElements(MarshallableElement ext, List elementFields, Element element) throws Spml2Exception {
        try {
            HashMap<String, Field> fieldsToProcess = new HashMap<String, Field>();
            ArrayList<Field> batchFields = new ArrayList<Field>();
            for (int k = 0; k < elementFields.size(); ++k) {
                ListWithType list;
                Class listType;
                Field field = (Field)elementFields.get(k);
                field.setAccessible(true);
                String name = ReflectionUtilities.getElementNameFromField(field);
                Class<?> fType = field.getType();
                if (ListWithType.class.isAssignableFrom(fType) && Marshallable.class.isAssignableFrom(listType = (list = (ListWithType)field.get(ext)).getType())) {
                    batchFields.add(field);
                }
                fieldsToProcess.put(name, field);
            }
            Set elementNames = fieldsToProcess.keySet();
            for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                OpenContentElement ocElement;
                if (node.getNodeType() != 1) continue;
                String elName = node.getLocalName();
                if (elementNames.contains(elName)) {
                    Node firstKid;
                    String nodeValue;
                    Field field = (Field)fieldsToProcess.get(elName);
                    Class<?> fType = field.getType();
                    if (ListWithType.class.isAssignableFrom(fType)) {
                        Class typeToCreate = this.getTypeFromField(ext, field);
                        MarshallableElement child = ObjectFactory.getInstance().createMarshallableElement(typeToCreate);
                        this.populate(child, (Element)node);
                        ListWithType values = (ListWithType)field.get(ext);
                        values.add(child);
                        continue;
                    }
                    if (MarshallableElement.class.isAssignableFrom(fType)) {
                        MarshallableElement child = ObjectFactory.getInstance().createMarshallableElement(fType);
                        this.populate(child, (Element)node);
                        field.set(ext, child);
                        continue;
                    }
                    if (fType.isArray()) {
                        if (fType.getComponentType() == String.class) {
                            String[] val = (String[])field.get(ext);
                            if (val == null || val.length != 1) {
                                throw new Spml2Exception("Unexpected length of String[] field: " + field);
                            }
                            nodeValue = node.getNodeValue();
                            if (nodeValue == null && (firstKid = node.getFirstChild()) != null) {
                                nodeValue = firstKid.getNodeValue();
                            }
                            val[0] = nodeValue;
                            continue;
                        }
                        throw new Spml2Exception("Unexpected field type: " + field);
                    }
                    if (!Collection.class.isAssignableFrom(fType)) continue;
                    Collection c = (Collection)field.get(ext);
                    if (c == null) {
                        throw new Spml2Exception("Collection field with null value is unexpected, field: " + field);
                    }
                    nodeValue = node.getNodeValue();
                    if (nodeValue == null && (firstKid = node.getFirstChild()) != null) {
                        nodeValue = firstKid.getNodeValue();
                    }
                    if (nodeValue == null) continue;
                    c.add(nodeValue);
                    continue;
                }
                boolean batched = false;
                for (int k = 0; k < batchFields.size(); ++k) {
                    Field field = (Field)batchFields.get(k);
                    ListWithType list = (ListWithType)field.get(ext);
                    Marshallable m = null;
                    try {
                        m = this.createAndPopulateMarshallable(elName, (Element)node);
                        if (m instanceof OpenContentElement) continue;
                        list.add(m);
                        batched = true;
                        continue;
                    }
                    catch (UnknownSpml2TypeException e) {
                        // empty catch block
                    }
                }
                if (batched || !(ext instanceof OpenContentContainer) || (ocElement = ObjectFactory.getInstance().unmarshallOpenContentElement(node)) == null) continue;
                ((OpenContentContainer)((Object)ext)).addOpenContentElement(ocElement);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new Spml2Exception(e);
        }
    }

    private Class getTypeFromField(MarshallableElement parent, Field field) throws IllegalAccessException {
        Class<?> fType = field.getType();
        if (ListWithType.class.isAssignableFrom(fType)) {
            ListWithType val = (ListWithType)field.get(parent);
            assert (val != null);
            return val.getType();
        }
        return fType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReflectiveDOMXMLUnmarshaller() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (m4Marshallables == null) {
                m4Marshallables = new OCEUnmarshallerForMarshallables();
                ObjectFactory of = ObjectFactory.getInstance();
                of.addOCEUnmarshaller(m4Marshallables);
            }
        }
    }

    public Marshallable unmarshall(String xml) throws UnknownSpml2TypeException {
        try {
            Document doc = XmlParser.parse(xml);
            Element el = doc.getDocumentElement();
            String typeName = el.getTagName();
            return this.createAndPopulateMarshallable(typeName, el);
        }
        catch (Spml2Exception e) {
            throw new UnknownSpml2TypeException("SPML2 Parsing error, cannot unmarshall.\n  Message=\n" + e.getMessage() + "\n  XML=\n" + xml, e);
        }
    }

    private class OCEUnmarshallerForMarshallables
    implements ObjectFactory.OCEUnmarshaller {
        private OCEUnmarshallerForMarshallables() {
        }

        public OpenContentElement unmarshall(Object obj) throws Spml2Exception {
            if (obj instanceof Element) {
                Element el = (Element)obj;
                try {
                    Marshallable m = ReflectiveDOMXMLUnmarshaller.this.createAndPopulateMarshallable(el.getTagName(), el);
                    if (m != null) {
                        if (m instanceof OpenContentElement) {
                            return (OpenContentElement)((Object)m);
                        }
                        return new OCEtoMarshallableAdapter(m);
                    }
                }
                catch (UnknownSpml2TypeException unknownSpml2TypeException) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

