/*
 * Decompiled with CFR 0.152.
 */
package org.openspml.v2.util.xml;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openspml.v2.msg.MarshallableElement;
import org.openspml.v2.msg.PrefixAndNamespaceTuple;
import org.openspml.v2.msg.spml.Extensible;
import org.openspml.v2.util.Spml2Exception;

class ReflectionUtilities {
    private static final String code_id = "$Id: ReflectionUtilities.java,v 1.4 2006/08/30 18:02:59 kas Exp $";

    ReflectionUtilities() {
    }

    static void getAttributeAndElementFields(MarshallableElement e, List attributes, List elements) {
        ArrayList allClasses = new ArrayList();
        for (Class<?> cls = e.getClass(); cls != null && MarshallableElement.class.isAssignableFrom(cls); cls = cls.getSuperclass()) {
            allClasses.add(cls);
        }
        Collections.reverse(allClasses);
        for (int k = 0; k < allClasses.size(); ++k) {
            Class aClass = (Class)allClasses.get(k);
            Field[] fields = aClass.getDeclaredFields();
            for (int j = 0; j < fields.length; ++j) {
                Field field = fields[j];
                String fieldName = field.getName();
                if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers()) || !fieldName.startsWith("m_")) continue;
                Class<?> fieldType = field.getType();
                if (!(Extensible.class.isAssignableFrom(fieldType) || Collection.class.isAssignableFrom(fieldType) || fieldType.isArray())) {
                    attributes.add(field);
                    continue;
                }
                elements.add(field);
            }
        }
    }

    public static String getAttributeNameFromField(Field f) {
        return ReflectionUtilities.getElementNameFromField(f);
    }

    public static String getElementNameFromField(Field field) {
        return field.getName().substring(2);
    }

    public static String getPreferredPrefix(MarshallableElement me) throws Spml2Exception {
        PrefixAndNamespaceTuple[] tuples = me.getNamespacesInfo();
        if (tuples.length == 1 && tuples[0].isDefault) {
            return null;
        }
        for (int k = 0; k < tuples.length; ++k) {
            PrefixAndNamespaceTuple tuple = tuples[k];
            if (tuple.isDefault) continue;
            return tuple.prefix;
        }
        throw new Spml2Exception("The prefix and namespace declarations for the the MarshallableElement class " + me.getClass() + " are incorrect.");
    }
}

