/*
 * Decompiled with CFR 0.152.
 */
package org.openspml.v2.util.xml;

import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspml.v2.msg.Marshallable;
import org.openspml.v2.msg.MarshallableElement;
import org.openspml.v2.msg.OCEtoXMLStringAdapter;
import org.openspml.v2.msg.OpenContentElement;
import org.openspml.v2.util.Spml2Exception;
import org.openspml.v2.util.xml.OperationalNameValuePairCreator;
import org.openspml.v2.util.xml.UnknownSpml2TypeException;
import org.openspml.v2.util.xml.XmlUtil;
import org.w3c.dom.Element;

public class ObjectFactory {
    private static final String code_id = "$Id: ObjectFactory.java,v 1.16 2006/09/25 18:50:07 kas Exp $";
    private static final ObjectFactory mInstance;
    private final MarshallableCreator mDefaultCreator = new DefaultCreator();
    private final Object mCreatorsLock = new Object();
    private final List mCreators = new ArrayList();
    private final Object mOCEUnmarshallersLock = new Object();
    private final List mOCEUnmarshallers = new ArrayList();
    private OCEUnmarshaller mOCEForStrings = new OCEUnmarshallerForDOMElementAsString();
    private Map mRegistrarNameToRegistrar = new HashMap();

    private ObjectFactory() throws Spml2Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Marshallable createMarshallable(String name, String uri) throws UnknownSpml2TypeException {
        Marshallable m = null;
        try {
            Object object = this.mCreatorsLock;
            synchronized (object) {
                MarshallableCreator c;
                int size = this.mCreators.size();
                for (int k = 0; k < size && (m = (c = (MarshallableCreator)this.mCreators.get(k)).createMarshallable(name, uri)) == null; ++k) {
                }
            }
            if (m == null) {
                m = this.mDefaultCreator.createMarshallable(name, uri);
            }
        }
        catch (Spml2Exception e) {
            throw new UnknownSpml2TypeException("Unknown or unsupported SPML type, " + name, e);
        }
        if (m == null) {
            throw new UnknownSpml2TypeException("Unknown or unsupported SPML type, name=" + name + ", uri=" + uri);
        }
        return m;
    }

    public MarshallableElement createMarshallableElement(Class cls) throws UnknownSpml2TypeException {
        try {
            Constructor ctor = cls.getDeclaredConstructor(new Class[0]);
            ctor.setAccessible(true);
            return (MarshallableElement)ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new UnknownSpml2TypeException("Error creating SPML object. cls = " + cls, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOCEUnmarshaller(OCEUnmarshaller oceum) {
        Object object = this.mOCEUnmarshallersLock;
        synchronized (object) {
            if (!this.mOCEUnmarshallers.contains(oceum)) {
                this.mOCEUnmarshallers.add(oceum);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeOCEUnmarshaller(OCEUnmarshaller oceum) {
        Object object = this.mOCEUnmarshallersLock;
        synchronized (object) {
            return this.mOCEUnmarshallers.remove(oceum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenContentElement unmarshallOpenContentElement(Object obj) throws Spml2Exception {
        Object object = this.mOCEUnmarshallersLock;
        synchronized (object) {
            OCEUnmarshaller u;
            OpenContentElement oce = null;
            for (int k = 0; k < this.mOCEUnmarshallers.size() && (oce = (u = (OCEUnmarshaller)this.mOCEUnmarshallers.get(k)).unmarshall(obj)) == null; ++k) {
            }
            if (oce == null && System.getProperty("org.openspml.v2.adaptXMLStrings") != null) {
                oce = this.mOCEForStrings.unmarshall(obj);
            }
            return oce;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCreator(MarshallableCreator creator) {
        Object object = this.mCreatorsLock;
        synchronized (object) {
            this.mCreators.add(creator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeCreator(MarshallableCreator creator) {
        Object object = this.mCreatorsLock;
        synchronized (object) {
            return this.mCreators.remove(creator);
        }
    }

    public String register(ProfileRegistrar pr) {
        String pid = null;
        if (pr != null && (pid = pr.getProfileId()) != null && this.mRegistrarNameToRegistrar.get(pid) == null) {
            pr.register(this);
            this.mRegistrarNameToRegistrar.put(pid, pr);
        }
        return pid;
    }

    public boolean unregister(String profileId) {
        ProfileRegistrar pr;
        if (profileId != null && (pr = (ProfileRegistrar)this.mRegistrarNameToRegistrar.get(profileId)) != null) {
            pr.unregister(this);
            return true;
        }
        return false;
    }

    public boolean unregister(ProfileRegistrar pr) {
        return this.unregister(pr.getProfileId());
    }

    public static ObjectFactory getInstance() {
        return mInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Class<ObjectFactory> clazz = ObjectFactory.class;
        synchronized (ObjectFactory.class) {
            try {
                mInstance = new ObjectFactory();
                mInstance.addCreator(new OperationalNameValuePairCreator());
            }
            catch (Spml2Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
            return;
        }
    }

    public static interface ProfileRegistrar {
        public String getProfileId();

        public URI getProfileURI() throws Spml2Exception;

        public void register(ObjectFactory var1);

        public void unregister(ObjectFactory var1);
    }

    private static class OCEUnmarshallerForDOMElementAsString
    implements OCEUnmarshaller {
        private OCEUnmarshallerForDOMElementAsString() {
        }

        public OpenContentElement unmarshall(Object obj) throws Spml2Exception {
            if (obj instanceof Element) {
                Element el = (Element)obj;
                String xml = XmlUtil.serializeNode(el);
                xml = xml + "\n";
                xml = XmlUtil.makeXmlFragmentFromDoc(xml);
                return new OCEtoXMLStringAdapter(xml);
            }
            return null;
        }
    }

    public static interface OCEUnmarshaller {
        public OpenContentElement unmarshall(Object var1) throws Spml2Exception;
    }

    public static interface MarshallableCreator {
        public Marshallable createMarshallable(String var1, String var2) throws Spml2Exception;
    }

    private class DefaultCreator
    implements MarshallableCreator {
        private Map mURIToPackage = new HashMap();
        private Map mMarshallableNameToClass = new HashMap();

        private DefaultCreator() throws Spml2Exception {
            String[][] uriToPackage = new String[][]{{"urn:oasis:names:tc:SPML:2:0", "org.openspml.v2.msg.spml"}, {"urn:oasis:names:tc:SPML:2:0:async", "org.openspml.v2.msg.spmlasync"}, {"urn:oasis:names:tc:SPML:2:0:batch", "org.openspml.v2.msg.spmlbatch"}, {"urn:oasis:names:tc:SPML:2:0:bulk", "org.openspml.v2.msg.spmlbulk"}, {"urn:oasis:names:tc:SPML:2:0:password", "org.openspml.v2.msg.pass"}, {"urn:oasis:names:tc:SPML:2:0:reference", "org.openspml.v2.msg.spmlref"}, {"urn:oasis:names:tc:SPML:2:0:search", "org.openspml.v2.msg.spmlsearch"}, {"urn:oasis:names:tc:SPML:2:0:suspend", "org.openspml.v2.msg.spmlsuspend"}, {"urn:oasis:names:tc:SPML:2:0:updates", "org.openspml.v2.msg.spmlupdates"}};
            for (int k = 0; k < uriToPackage.length; ++k) {
                String key = uriToPackage[k][0];
                String pkgName = uriToPackage[k][1];
                this.mURIToPackage.put(key, pkgName);
            }
            try {
                String[][] nameToClassname = new String[][]{{"select", "org.openspml.v2.msg.spml.Selection"}};
                for (int k = 0; k < nameToClassname.length; ++k) {
                    String key = nameToClassname[k][0];
                    String classname = nameToClassname[k][1];
                    this.mMarshallableNameToClass.put(key, Class.forName(classname));
                }
            }
            catch (ClassNotFoundException e) {
                throw new Spml2Exception("Missing classes in the jar?");
            }
        }

        private String firstCharToUpper(String cname) {
            String fChar = cname.substring(0, 1);
            fChar = fChar.toUpperCase();
            return fChar + cname.substring(1);
        }

        private Class findClass(String name, String uri) throws Spml2Exception {
            Class<?> cls = (Class<?>)this.mMarshallableNameToClass.get(name);
            if (cls == null) {
                int idx;
                String classname = "org.openspml.v2.msg.spml";
                String pkgName = (String)this.mURIToPackage.get(uri);
                if (pkgName != null) {
                    classname = pkgName;
                }
                if ((idx = name.indexOf(":")) != -1) {
                    name = name.substring(idx + 1);
                }
                classname = classname + "." + this.firstCharToUpper(name);
                try {
                    cls = Class.forName(classname);
                }
                catch (ClassNotFoundException e) {
                    throw new Spml2Exception(e);
                }
            }
            return cls;
        }

        public Marshallable createMarshallable(String nameAndPrefix, String uri) throws Spml2Exception {
            Class cls = this.findClass(nameAndPrefix, uri);
            if (cls == null) {
                return null;
            }
            MarshallableElement e = ObjectFactory.this.createMarshallableElement(cls);
            if (!(e instanceof Marshallable)) {
                throw new UnknownSpml2TypeException("That's just a MarshallableElement: " + nameAndPrefix + ", uri = " + uri);
            }
            return (Marshallable)e;
        }
    }
}

