/*
 * Decompiled with CFR 0.152.
 */
package org.openspml.v2.transport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import org.openspml.v2.msg.spml.ErrorCode;
import org.openspml.v2.msg.spml.Request;
import org.openspml.v2.msg.spml.Response;
import org.openspml.v2.msg.spml.StatusCode;
import org.openspml.v2.provider.SPMLExecutor;
import org.openspml.v2.provider.SPMLMarshaller;
import org.openspml.v2.transport.RPCDispatcher;
import org.openspml.v2.transport.Spml2TransportException;
import org.openspml.v2.util.ReflectionUtil;
import org.openspml.v2.util.Spml2Exception;
import org.openspml.v2.util.xml.XmlUtil;

public class SPMLViaSoapDispatcher
implements RPCDispatcher {
    private static final String code_id = "$Id: SPMLViaSoapDispatcher.java,v 1.5 2006/09/25 18:50:07 kas Exp $";
    private static final String INIT_PARAM_MARSHALLERS = "SpmlViaSoap.spmlMarshallers";
    private static final boolean REQUIRE_MARSHALLERS_PARAM = true;
    private static final String INIT_PARAM_EXECUTORS = "SpmlViaSoap.spmlExecutors";
    private static final boolean REQUIRE_EXECUTORS_PARAM = true;
    private SPMLMarshaller[] _marshallers;
    private SPMLExecutor[] _executors;

    public void init(Map config) throws Spml2TransportException {
        this._marshallers = this.initMarshallers(config);
        this._executors = this.initExecutors(config);
    }

    public String dispatchRequest(String inMessage) throws Spml2TransportException {
        try {
            String result;
            String unwrappedMessage = this.unwrapRequest(inMessage);
            Request request = null;
            SPMLMarshaller marshaller = null;
            for (int m = 0; request == null && m < this._marshallers.length; ++m) {
                marshaller = this._marshallers[m];
                request = marshaller.unmarshallRequest(unwrappedMessage);
            }
            if (request == null) {
                return null;
            }
            Response response = null;
            for (int o = 0; response == null && o < this._executors.length; ++o) {
                SPMLExecutor executor = this._executors[o];
                response = executor.execute(request);
            }
            if (response == null) {
                response = new Response();
                response.setError(ErrorCode.UNSUPPORTED_OPERATION);
                response.setStatus(StatusCode.FAILURE);
                response.addErrorMessage(request.getClass().getName());
            }
            if ((result = marshaller.marshallResponse(response)) == null) {
                throw new Spml2TransportException("The marshaller, " + marshaller.getUniqueName() + ", could not marshall:\n" + response);
            }
            return this.wrapResponse(result);
        }
        catch (Spml2Exception e) {
            throw new Spml2TransportException(e);
        }
    }

    public String getContentType() {
        return "text/xml; charset=UTF-8";
    }

    protected SPMLMarshaller[] initMarshallers(Map config) throws Spml2TransportException {
        String marshallers = (String)config.get(INIT_PARAM_MARSHALLERS);
        if (marshallers == null) {
            throw new Spml2TransportException("Missing init-param: SpmlViaSoap.spmlMarshallers");
        }
        try {
            ArrayList<SPMLMarshaller> list = new ArrayList<SPMLMarshaller>();
            String[] classNames = marshallers.split(",");
            for (int k = 0; k < classNames.length; ++k) {
                Object o = ReflectionUtil.instantiate(classNames[k]);
                if (o instanceof SPMLMarshaller) {
                    SPMLMarshaller m = (SPMLMarshaller)o;
                    list.add(m);
                    String prefix = "SpmlViaSoap.spmlMarshallers." + m.getUniqueName();
                    m.init(this.getInitArgsAsMap(prefix, config));
                    continue;
                }
                if (o == null) continue;
                System.err.print(this.getClass() + ": " + classNames[k] + " does not implement " + SPMLMarshaller.class.getName());
            }
            if (list.size() == 0) {
                throw new Spml2TransportException("The init-param, SpmlViaSoap.spmlMarshallers, did not define any valid SPMLMarshaller classes.");
            }
            return list.toArray(new SPMLMarshaller[list.size()]);
        }
        catch (Spml2Exception e) {
            throw new Spml2TransportException(e);
        }
    }

    protected SPMLExecutor[] initExecutors(Map config) throws Spml2TransportException {
        try {
            String executors = (String)config.get(INIT_PARAM_EXECUTORS);
            if (executors == null) {
                throw new ServletException("Missing init-param: SpmlViaSoap.spmlExecutors");
            }
            ArrayList<SPMLExecutor> list = new ArrayList<SPMLExecutor>();
            String[] classNames = executors.split(",");
            for (int k = 0; k < classNames.length; ++k) {
                Object o = ReflectionUtil.instantiate(classNames[k]);
                if (o instanceof SPMLExecutor) {
                    SPMLExecutor op = (SPMLExecutor)o;
                    list.add(op);
                    String prefix = "SpmlViaSoap.spmlExecutors." + op.getUniqueName();
                    op.init(this.getInitArgsAsMap(prefix, config));
                    continue;
                }
                if (o == null) continue;
                System.err.print(this.getClass() + ": " + classNames[k] + " does not implement " + SPMLExecutor.class.getName());
            }
            if (list.size() == 0) {
                throw new Spml2TransportException("The init-param, SpmlViaSoap.spmlExecutors, did not define any valid SPMLExecutor classes.");
            }
            return list.toArray(new SPMLExecutor[list.size()]);
        }
        catch (Exception e) {
            throw new Spml2TransportException(e);
        }
    }

    private Map getInitArgsAsMap(String prefix, Map config) {
        HashMap result = new HashMap();
        for (String name : config.keySet()) {
            if (!name.startsWith(prefix)) continue;
            String key = name.substring(prefix.length() + 1);
            result.put(key, config.get(name));
        }
        return result;
    }

    protected String unwrapRequest(String message) throws Spml2Exception {
        return XmlUtil.getSoapBodyContents(message);
    }

    protected String wrapResponse(String result) {
        StringBuffer b = new StringBuffer();
        b.append("<?xml version='1.0' encoding='UTF-8'?>\n");
        b.append("<SOAP-ENV:Envelope\n");
        b.append("  xmlns:SOAP-ENV='http://schemas.xmlsoap.org/soap/envelope/'>\n");
        b.append("<SOAP-ENV:Body>\n");
        b.append(result);
        b.append("</SOAP-ENV:Body>\n");
        b.append("</SOAP-ENV:Envelope>\n");
        return b.toString();
    }
}

