/*
 * Decompiled with CFR 0.152.
 */
package org.openspml.v2.profiles.dsml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.openspml.v2.profiles.dsml.DSMLProfileException;
import org.openspml.v2.profiles.dsml.DSMLUnmarshaller;
import org.openspml.v2.profiles.dsml.DSMLValue;
import org.openspml.v2.profiles.dsml.FilterItemVisitor;
import org.openspml.v2.profiles.dsml.NamedFilterItem;
import org.openspml.v2.util.xml.XmlBuffer;

public class Substrings
extends NamedFilterItem {
    private static final String code_id = "$Id: Substrings.java,v 1.11 2006/08/30 18:02:59 kas Exp $";
    private DSMLValue mInitial = null;
    private List mAny = new ArrayList();
    private DSMLValue mFinal = null;

    public Substrings() {
    }

    public Substrings(String name) throws DSMLProfileException {
        super(name);
    }

    public Substrings(String name, DSMLValue initial, DSMLValue[] any, DSMLValue aFinal) throws DSMLProfileException {
        super(name);
        this.mInitial = initial;
        this.mAny = Arrays.asList(any);
        this.mFinal = aFinal;
    }

    protected void toXML(XmlBuffer buffer) throws DSMLProfileException {
        super.toXML("substrings", buffer);
    }

    protected void addSubclassElements(XmlBuffer buffer) throws DSMLProfileException {
        if (this.mInitial != null) {
            this.mInitial.toXML("initial", buffer);
        }
        for (int k = 0; k < this.mAny.size(); ++k) {
            DSMLValue value = (DSMLValue)this.mAny.get(k);
            value.toXML("any", buffer);
        }
        if (this.mFinal != null) {
            this.mFinal.toXML("final", buffer);
        }
    }

    public void parseXml(DSMLUnmarshaller um, Object e) throws DSMLProfileException {
        um.visitSubstrings(this, e);
    }

    public DSMLValue getInitial() {
        return this.mInitial;
    }

    public void setInitial(DSMLValue initial) {
        this.mInitial = initial;
    }

    public DSMLValue[] getAny() {
        return this.mAny.toArray(new DSMLValue[this.mAny.size()]);
    }

    public String[] getAnyStrings() {
        ArrayList<String> strings = new ArrayList<String>();
        for (DSMLValue dsmlValue : this.mAny) {
            strings.add(dsmlValue.toString());
        }
        return strings.toArray(new String[strings.size()]);
    }

    public void setAny(DSMLValue[] any) {
        if (any != null) {
            this.mAny.clear();
            this.mAny.addAll(Arrays.asList(any));
        }
    }

    public void addAny(DSMLValue any) {
        if (any != null) {
            this.mAny.add(any);
        }
    }

    public boolean removeAny(DSMLValue any) {
        if (any != null) {
            return this.mAny.remove(any);
        }
        return false;
    }

    public void clearAny() {
        this.mAny.clear();
    }

    public DSMLValue getFinal() {
        return this.mFinal;
    }

    public void setFinal(DSMLValue aFinal) {
        this.mFinal = aFinal;
    }

    public boolean matches(Map attrs) throws DSMLProfileException {
        if (attrs == null) {
            return false;
        }
        List valuesToTest = (List)attrs.get(this.getName());
        if (valuesToTest == null || valuesToTest.size() == 0) {
            return false;
        }
        String finalString = this.mFinal == null ? null : this.mFinal.toString();
        String initialString = this.mInitial == null ? null : this.mInitial.toString();
        String[] anyStrings = this.mAny.isEmpty() ? null : this.getAnyStrings();
        boolean matches = false;
        block0: for (int k = 0; !matches && k < valuesToTest.size(); ++k) {
            String dsmlValue = (String)valuesToTest.get(k);
            String valueString = dsmlValue.toString();
            if (this.mInitial != null) {
                if (!valueString.startsWith(initialString)) continue;
                matches = true;
                continue;
            }
            if (finalString != null) {
                if (!valueString.endsWith(finalString)) continue;
                matches = true;
                continue;
            }
            if (anyStrings == null) continue;
            for (int j = 0; j < anyStrings.length; ++j) {
                String anyString = anyStrings[j];
                if (valueString.indexOf(anyString) < 0) continue;
                matches = true;
                continue block0;
            }
        }
        return matches;
    }

    public void accept(FilterItemVisitor visitor) throws DSMLProfileException {
        visitor.visitSubstrings(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Substrings)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Substrings substrings = (Substrings)o;
        if (this.mAny != null ? !((Object)this.mAny).equals(substrings.mAny) : substrings.mAny != null) {
            return false;
        }
        if (this.mFinal != null ? !this.mFinal.equals(substrings.mFinal) : substrings.mFinal != null) {
            return false;
        }
        return !(this.mInitial != null ? !this.mInitial.equals(substrings.mInitial) : substrings.mInitial != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.mInitial != null ? this.mInitial.hashCode() : 0);
        result = 29 * result + (this.mAny != null ? ((Object)this.mAny).hashCode() : 0);
        result = 29 * result + (this.mFinal != null ? this.mFinal.hashCode() : 0);
        return result;
    }
}

