/*
 * Decompiled with CFR 0.152.
 */
package org.openspml.v2.profiles.dsml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openspml.v2.profiles.dsml.DSMLProfileException;
import org.openspml.v2.profiles.dsml.DSMLUnmarshaller;
import org.openspml.v2.profiles.dsml.FilterItem;
import org.openspml.v2.util.xml.XmlBuffer;

public abstract class FilterSet
extends FilterItem {
    private static final String code_id = "$Id: FilterSet.java,v 1.6 2006/07/20 01:22:14 kas Exp $";
    private List mItems = new ArrayList();

    protected void toXML(String s, XmlBuffer buffer) throws DSMLProfileException {
        buffer.addStartTag(s);
        buffer.incIndent();
        for (int k = 0; k < this.mItems.size(); ++k) {
            FilterItem filterItem = (FilterItem)this.mItems.get(k);
            filterItem.toXML(buffer);
        }
        buffer.decIndent();
        buffer.addEndTag(s);
    }

    public void parseXml(DSMLUnmarshaller um, Object e) throws DSMLProfileException {
        um.visitFilterSet(this, e);
    }

    public FilterSet(FilterItem[] items) {
        this.setItems(items);
    }

    public FilterSet(FilterItem item) {
        this.mItems.add(item);
    }

    public FilterSet() {
    }

    public FilterItem[] getItems() {
        return this.mItems.toArray(new FilterItem[this.mItems.size()]);
    }

    public void setItems(FilterItem[] items) {
        this.mItems.clear();
        this.mItems.addAll(Arrays.asList(items));
    }

    public void addItems(FilterItem[] items) {
        this.mItems.addAll(Arrays.asList(items));
    }

    public void addItem(FilterItem item) {
        this.mItems.add(item);
    }

    public boolean removeItem(FilterItem item) {
        return this.mItems.remove(item);
    }

    public void clearItems() {
        this.mItems.clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FilterSet)) {
            return false;
        }
        FilterSet filterSet = (FilterSet)o;
        return !(this.mItems != null ? !((Object)this.mItems).equals(filterSet.mItems) : filterSet.mItems != null);
    }

    public int hashCode() {
        return this.mItems != null ? ((Object)this.mItems).hashCode() : 0;
    }
}

