/*
 * Decompiled with CFR 0.152.
 */
package org.openspml.v2.profiles.dsml;

import java.util.ArrayList;
import org.openspml.v2.msg.OpenContentElement;
import org.openspml.v2.msg.spml.ModificationMode;
import org.openspml.v2.profiles.dsml.And;
import org.openspml.v2.profiles.dsml.ApproxMatch;
import org.openspml.v2.profiles.dsml.AttributeDescription;
import org.openspml.v2.profiles.dsml.AttributeDescriptions;
import org.openspml.v2.profiles.dsml.AttributeValueAssertion;
import org.openspml.v2.profiles.dsml.BasicFilter;
import org.openspml.v2.profiles.dsml.DSMLAttr;
import org.openspml.v2.profiles.dsml.DSMLModification;
import org.openspml.v2.profiles.dsml.DSMLProfileException;
import org.openspml.v2.profiles.dsml.DSMLValue;
import org.openspml.v2.profiles.dsml.EqualityMatch;
import org.openspml.v2.profiles.dsml.ExtensibleMatch;
import org.openspml.v2.profiles.dsml.Filter;
import org.openspml.v2.profiles.dsml.FilterItem;
import org.openspml.v2.profiles.dsml.FilterSet;
import org.openspml.v2.profiles.dsml.GreaterOrEqual;
import org.openspml.v2.profiles.dsml.LessOrEqual;
import org.openspml.v2.profiles.dsml.NamedFilterItem;
import org.openspml.v2.profiles.dsml.Not;
import org.openspml.v2.profiles.dsml.Or;
import org.openspml.v2.profiles.dsml.Present;
import org.openspml.v2.profiles.dsml.Substrings;
import org.openspml.v2.util.xml.ObjectFactory;
import org.openspml.v2.util.xml.XmlElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DSMLUnmarshaller
implements ObjectFactory.OCEUnmarshaller {
    private static final String code_id = "$Id: DSMLUnmarshaller.java,v 1.9 2006/08/11 23:05:48 kas Exp $";
    protected static final String DSML_CORE_URI = "urn:oasis:names:tc:DSML:2:0:core";

    private FilterItem createFilterItem(String localName) {
        FilterItem result = null;
        if (localName != null) {
            if (localName.equals("and")) {
                result = new And();
            } else if (localName.equals("or")) {
                result = new Or();
            } else if (localName.equals("not")) {
                result = new Not();
            } else if (localName.equals("equalityMatch")) {
                result = new EqualityMatch();
            } else if (localName.equals("substrings")) {
                result = new Substrings();
            } else if (localName.equals("greaterOrEqual")) {
                result = new GreaterOrEqual();
            } else if (localName.equals("lessOrEqual")) {
                result = new LessOrEqual();
            } else if (localName.equals("present")) {
                result = new Present();
            } else if (localName.equals("approxMatch")) {
                result = this.createApproxMatch();
            } else if (localName.equals("extensibleMatch")) {
                result = this.createExtensibleMatch();
            }
        }
        return result;
    }

    private void throwUnknownXmlRep(Parseable p, Object obj) throws DSMLProfileException {
        throw new DSMLProfileException("Could not parse type " + p.getClass().getName() + ", with representation " + obj.toString() + ", of class " + obj.getClass().getName() + ".");
    }

    private DSMLValue[] getValuesFromXml(XmlElement e) {
        ArrayList<DSMLValue> values = new ArrayList<DSMLValue>();
        for (XmlElement child = e.getChildElement(); child != null; child = child.next()) {
            values.add(new DSMLValue(child.getContent()));
        }
        return values.toArray(new DSMLValue[values.size()]);
    }

    protected ExtensibleMatch createExtensibleMatch() {
        return new ExtensibleMatch();
    }

    protected ApproxMatch createApproxMatch() {
        return new ApproxMatch();
    }

    protected DSMLAttr visitDSMLAttr(DSMLAttr item, Object xmlObj) throws DSMLProfileException {
        if ((xmlObj = this.conditionallyWrapElement(xmlObj)) instanceof XmlElement) {
            XmlElement e = (XmlElement)xmlObj;
            String name = e.getAttribute("name");
            if (name == null) {
                throw new DSMLProfileException("No 'name' attribute in the object (Attribute|Modification)!");
            }
            DSMLValue[] values = this.getValuesFromXml(e);
            item.setName(name);
            item.setValues(values);
        } else {
            this.throwUnknownXmlRep(item, xmlObj);
        }
        return item;
    }

    protected DSMLModification visitDSMLModification(DSMLModification item, Object xmlObj) throws DSMLProfileException {
        if ((xmlObj = this.conditionallyWrapElement(xmlObj)) instanceof XmlElement) {
            XmlElement e = (XmlElement)xmlObj;
            String name = e.getAttribute("name");
            String operation = e.getAttribute("operation");
            DSMLValue[] values = this.getValuesFromXml(e);
            item.setName(name);
            item.setValues(values);
            item.setOperation(ModificationMode.getConstant(operation));
        } else {
            this.throwUnknownXmlRep(item, xmlObj);
        }
        return item;
    }

    protected FilterItem getFilterItem(Object xmlObj) throws DSMLProfileException {
        if ((xmlObj = this.conditionallyWrapElement(xmlObj)) instanceof XmlElement) {
            XmlElement e = (XmlElement)xmlObj;
            for (XmlElement child = e.getChildElement(); child != null; child = child.next()) {
                FilterItem item = this.createFilterItem(child.getLocalName());
                if (item == null) continue;
                item.parseXml(this, child);
                return item;
            }
        }
        throw new DSMLProfileException("Parsing error: this must have one FilterItem element.");
    }

    private Object conditionallyWrapElement(Object xmlObj) {
        if (xmlObj instanceof Element) {
            xmlObj = new XmlElement((Element)xmlObj);
        }
        return xmlObj;
    }

    protected AttributeDescriptions visitAttributeDescriptions(AttributeDescriptions item, Object xmlObj) throws DSMLProfileException {
        if ((xmlObj = this.conditionallyWrapElement(xmlObj)) instanceof XmlElement) {
            XmlElement e = (XmlElement)xmlObj;
            item.clearAttributeDescriptions();
            for (XmlElement child = e.getChildElement(); child != null; child = child.next()) {
                AttributeDescription desc = new AttributeDescription();
                desc.parseXml(this, child);
                item.addAttributeDescription(desc);
            }
        } else {
            this.throwUnknownXmlRep(item, xmlObj);
        }
        return item;
    }

    protected AttributeDescription visitAttributeDescription(AttributeDescription item, Object xmlObj) throws DSMLProfileException {
        if ((xmlObj = this.conditionallyWrapElement(xmlObj)) instanceof XmlElement) {
            XmlElement e = (XmlElement)xmlObj;
            String name = e.getAttribute("name");
            if (name == null) {
                throw new DSMLProfileException("XML error: No 'name' attribute in the AttributeDescription!");
            }
            item.setName(name);
        } else {
            this.throwUnknownXmlRep(item, xmlObj);
        }
        return item;
    }

    public OpenContentElement unmarshall(Object obj) throws DSMLProfileException {
        Node node;
        if (obj instanceof Node && (node = (Node)obj).getNodeType() == 1 && DSML_CORE_URI.equals(node.getNamespaceURI())) {
            Parseable p = null;
            String localName = node.getLocalName();
            if ("attr".equals(localName)) {
                p = new DSMLAttr();
            } else if ("modification".equals(localName)) {
                p = new DSMLModification();
            } else if ("filter".equals(localName)) {
                p = new Filter();
            } else if ("attributes".equals(localName)) {
                p = new AttributeDescriptions();
            }
            if (p != null) {
                p.parseXml(this, node);
                return p;
            }
        }
        return null;
    }

    protected Parseable visitFilterSet(FilterSet item, Object xmlObj) throws DSMLProfileException {
        if ((xmlObj = this.conditionallyWrapElement(xmlObj)) instanceof XmlElement) {
            XmlElement e = (XmlElement)xmlObj;
            for (XmlElement child = e.getChildElement(); child != null; child = child.next()) {
                FilterItem fi = this.createFilterItem(child.getLocalName());
                fi.parseXml(this, child);
                if (item == null) continue;
                item.addItem(fi);
            }
        } else {
            this.throwUnknownXmlRep(item, xmlObj);
        }
        return item;
    }

    protected BasicFilter visitBasicFilter(BasicFilter item, Object xmlObj) throws DSMLProfileException {
        FilterItem fi = this.getFilterItem(xmlObj);
        if (fi != null) {
            item.setItem(fi);
        } else {
            this.throwUnknownXmlRep(item, xmlObj);
        }
        return item;
    }

    protected Not visitNot(Not not, Object xmlObj) throws DSMLProfileException {
        FilterItem fi = this.getFilterItem(xmlObj);
        if (fi != null) {
            not.setItem(fi);
        } else {
            this.throwUnknownXmlRep(not, xmlObj);
        }
        return not;
    }

    private void populateNFI(NamedFilterItem nfi, XmlElement e) throws DSMLProfileException {
        String name = e.getAttribute("name");
        if (name == null) {
            throw new DSMLProfileException("XML error: No 'name' attribute in the FilterItem!");
        }
        nfi.setName(name);
    }

    protected NamedFilterItem visitNamedFilterItem(NamedFilterItem nfi, Object xmlObj) throws DSMLProfileException {
        if ((xmlObj = this.conditionallyWrapElement(xmlObj)) instanceof XmlElement) {
            XmlElement e = (XmlElement)xmlObj;
            this.populateNFI(nfi, e);
        } else {
            this.throwUnknownXmlRep(nfi, xmlObj);
        }
        return nfi;
    }

    protected AttributeValueAssertion visitAttributeValueAssertion(AttributeValueAssertion ava, Object xmlObj) throws DSMLProfileException {
        if ((xmlObj = this.conditionallyWrapElement(xmlObj)) instanceof XmlElement) {
            XmlElement e = (XmlElement)xmlObj;
            this.populateNFI(ava, e);
            for (XmlElement child = e.getChildElement(); child != null; child = child.next()) {
                String ln;
                if (!DSML_CORE_URI.equals(child.getNamespaceURI()) || !"value".equals(ln = child.getLocalName())) continue;
                if (ava.getValue() == null) {
                    ava.setValue(new DSMLValue(child.getContent()));
                    continue;
                }
                throw new DSMLProfileException("Parsing error: only one Value element is allowed.");
            }
        } else {
            this.throwUnknownXmlRep(ava, xmlObj);
        }
        return ava;
    }

    protected Parseable visitSubstrings(Substrings substrings, Object xmlObj) throws DSMLProfileException {
        if ((xmlObj = this.conditionallyWrapElement(xmlObj)) instanceof XmlElement) {
            XmlElement e = (XmlElement)xmlObj;
            this.populateNFI(substrings, e);
            for (XmlElement child = e.getChildElement(); child != null; child = child.next()) {
                if (!DSML_CORE_URI.equals(child.getNamespaceURI())) continue;
                String ln = child.getLocalName();
                if ("initial".equals(ln)) {
                    if (substrings.getInitial() == null) {
                        substrings.setInitial(new DSMLValue(child.getContent()));
                        continue;
                    }
                    throw new DSMLProfileException("Parsing error: only one initial element is allowed.");
                }
                if ("any".equals(ln)) {
                    DSMLValue v = new DSMLValue(child.getContent());
                    substrings.addAny(v);
                    continue;
                }
                if (!"final".equals(ln)) continue;
                if (substrings.getFinal() == null) {
                    substrings.setFinal(new DSMLValue(child.getContent()));
                    continue;
                }
                throw new DSMLProfileException("Parsing error: only one final element is allowed.");
            }
        } else {
            this.throwUnknownXmlRep(substrings, xmlObj);
        }
        return substrings;
    }

    public void visitExtensibleMatch(ExtensibleMatch em, Object xmlObj) throws DSMLProfileException {
        if ((xmlObj = this.conditionallyWrapElement(xmlObj)) instanceof XmlElement) {
            XmlElement e = (XmlElement)xmlObj;
            this.populateNFI(em, e);
            for (XmlElement child = e.getChildElement(); child != null; child = child.next()) {
                if (!DSML_CORE_URI.equals(child.getNamespaceURI())) continue;
                String ln = child.getLocalName();
                if ("dnAttributes".equals(ln)) {
                    Boolean dnAttrs = new Boolean(child.getContent());
                    em.setDnAttributes(dnAttrs);
                    continue;
                }
                if ("matchingRule".equals(ln)) {
                    em.setMatchingRule(child.getContent());
                    continue;
                }
                if (!"value".equals(ln)) continue;
                if (em.getValue() == null) {
                    em.setValue(new DSMLValue(child.getContent()));
                    continue;
                }
                throw new DSMLProfileException("Parsing error: only one Value element is allowed.");
            }
        } else {
            this.throwUnknownXmlRep(em, xmlObj);
        }
    }

    protected static interface Parseable {
        public void parseXml(DSMLUnmarshaller var1, Object var2) throws DSMLProfileException;
    }
}

