/*
 * Decompiled with CFR 0.152.
 */
package org.openspml.v2.profiles.dsml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openspml.v2.msg.OpenContentElement;
import org.openspml.v2.profiles.dsml.DSMLProfileException;
import org.openspml.v2.profiles.dsml.DSMLUnmarshaller;
import org.openspml.v2.profiles.dsml.DSMLValue;
import org.openspml.v2.profiles.dsml.NamedItem;
import org.openspml.v2.util.xml.XmlBuffer;

public class DSMLAttr
extends NamedItem
implements DSMLUnmarshaller.Parseable,
OpenContentElement {
    public static final String RESERVED_TYPE_ATTR_NAME = "objectclass";
    private List mValues = new ArrayList();

    protected DSMLAttr() {
    }

    public DSMLAttr(String name, String value) throws DSMLProfileException {
        this.setName(name);
        if (value != null) {
            this.mValues.add(new DSMLValue(value));
        }
    }

    public DSMLAttr(String name, DSMLValue[] values) throws DSMLProfileException {
        this.setName(name);
        if (values != null) {
            this.mValues.addAll(Arrays.asList(values));
        }
    }

    public DSMLValue[] getValues() {
        return this.mValues.toArray(new DSMLValue[this.mValues.size()]);
    }

    public void addValue(DSMLValue value) {
        if (value != null) {
            this.mValues.add(value);
        }
    }

    public void addValues(DSMLValue[] values) {
        for (int k = 0; k < values.length; ++k) {
            DSMLValue value = values[k];
            this.addValue(value);
        }
    }

    public void setValues(DSMLValue[] values) {
        this.clearValues();
        this.addValues(values);
    }

    public void clearValues() {
        this.mValues.clear();
    }

    public int numValues() {
        return this.mValues.size();
    }

    protected void addSubclassElements(XmlBuffer buffer) throws DSMLProfileException {
        super.addSubclassElements(buffer);
        DSMLValue[] mVals = this.getValues();
        for (int k = 0; k < mVals.length; ++k) {
            mVals[k].toXML(buffer);
        }
    }

    public String toXML(int indent) throws DSMLProfileException {
        return super.toXML("attr", indent);
    }

    public String toXML() throws DSMLProfileException {
        return this.toXML(0);
    }

    public void parseXml(DSMLUnmarshaller m, Object xmlObj) throws DSMLProfileException {
        m.visitDSMLAttr(this, xmlObj);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DSMLAttr)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DSMLAttr attr = (DSMLAttr)o;
        return !(this.mValues != null ? !((Object)this.mValues).equals(attr.mValues) : attr.mValues != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.mValues != null ? ((Object)this.mValues).hashCode() : 0);
        return result;
    }
}

