/*
 * Decompiled with CFR 0.152.
 */
package org.openspml.v2.msg.spmlsearch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.openspml.v2.msg.Marshallable;
import org.openspml.v2.msg.OpenContentElement;
import org.openspml.v2.msg.PrefixAndNamespaceTuple;
import org.openspml.v2.msg.XMLMarshaller;
import org.openspml.v2.msg.spml.Extensible;
import org.openspml.v2.msg.spml.PSOIdentifier;
import org.openspml.v2.msg.spml.QueryClause;
import org.openspml.v2.msg.spmlsearch.NamespaceDefinitions;
import org.openspml.v2.msg.spmlsearch.Scope;
import org.openspml.v2.util.Spml2Exception;
import org.openspml.v2.util.xml.ArrayListWithType;
import org.openspml.v2.util.xml.ListWithType;

public abstract class SearchQuery
extends Extensible
implements Marshallable {
    private static final String code_id = "$Id: SearchQuery.java,v 1.8 2006/08/30 18:02:59 kas Exp $";
    private ListWithType m_queryClauses = new ArrayListWithType(QueryClause.class);
    private PSOIdentifier m_basePsoID = null;
    private String m_targetID = null;
    private Scope m_scope = null;

    protected SearchQuery() {
    }

    protected SearchQuery(QueryClause[] queryClauses, PSOIdentifier basePsoID, String targetID, Scope scope) {
        assert (queryClauses != null);
        assert (queryClauses.length != 0);
        for (int k = 0; k < queryClauses.length; ++k) {
            if (queryClauses[k] == null) continue;
            this.m_queryClauses.add(queryClauses[k]);
        }
        assert (!this.m_queryClauses.isEmpty());
        this.m_basePsoID = basePsoID;
        this.m_targetID = targetID;
        this.m_scope = scope;
    }

    public QueryClause[] getQueryClauses() {
        ArrayList<OpenContentElement> temp = new ArrayList<OpenContentElement>();
        temp.addAll(this.m_queryClauses);
        OpenContentElement[] oces = this.getOpenContentElements();
        for (int k = 0; k < oces.length; ++k) {
            OpenContentElement oce = oces[k];
            if (!(oce instanceof QueryClause)) continue;
            temp.add(oce);
        }
        return temp.toArray(new QueryClause[temp.size()]);
    }

    public void clearQueryClauses() {
        this.m_queryClauses.clear();
        OpenContentElement[] elements = this.getOpenContentElements();
        for (int k = 0; k < elements.length; ++k) {
            OpenContentElement element = elements[k];
            if (!(element instanceof QueryClause)) continue;
            this.removeOpenContentElement(element);
        }
    }

    public void addQueryClause(QueryClause queryClause) {
        if (queryClause == null) {
            return;
        }
        if (queryClause instanceof OpenContentElement) {
            this.addOpenContentElement((OpenContentElement)((Object)queryClause));
        } else {
            this.m_queryClauses.add(queryClause);
        }
    }

    public boolean removeQueryClause(QueryClause queryClause) {
        if (queryClause == null) {
            return false;
        }
        if (queryClause instanceof OpenContentElement) {
            return this.removeOpenContentElement((OpenContentElement)((Object)queryClause));
        }
        return this.m_queryClauses.remove(queryClause);
    }

    public PSOIdentifier getBasePsoID() {
        return this.m_basePsoID;
    }

    public void setBasePsoID(PSOIdentifier basePsoID) {
        this.m_basePsoID = basePsoID;
    }

    public String getTargetID() {
        return this.m_targetID;
    }

    public void setTargetID(String targetID) {
        this.m_targetID = targetID;
    }

    public Scope getScope() {
        return this.m_scope;
    }

    public void setScope(Scope scope) {
        this.m_scope = scope;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SearchQuery)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SearchQuery searchQuery = (SearchQuery)o;
        if (this.m_basePsoID != null ? !this.m_basePsoID.equals(searchQuery.m_basePsoID) : searchQuery.m_basePsoID != null) {
            return false;
        }
        if (!this.m_queryClauses.equals(searchQuery.m_queryClauses)) {
            return false;
        }
        if (this.m_scope != null ? !this.m_scope.equals(searchQuery.m_scope) : searchQuery.m_scope != null) {
            return false;
        }
        return !(this.m_targetID != null ? !this.m_targetID.equals(searchQuery.m_targetID) : searchQuery.m_targetID != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + this.m_queryClauses.hashCode();
        result = 29 * result + (this.m_basePsoID != null ? this.m_basePsoID.hashCode() : 0);
        result = 29 * result + (this.m_targetID != null ? this.m_targetID.hashCode() : 0);
        result = 29 * result + (this.m_scope != null ? this.m_scope.hashCode() : 0);
        return result;
    }

    public PrefixAndNamespaceTuple[] getNamespacesInfo() {
        PrefixAndNamespaceTuple[] ours = PrefixAndNamespaceTuple.concatNamespacesInfo(super.getNamespacesInfo(), NamespaceDefinitions.getMarshallableNamespacesInfo());
        LinkedHashSet<PrefixAndNamespaceTuple> all = new LinkedHashSet<PrefixAndNamespaceTuple>(Arrays.asList(ours));
        for (QueryClause qc : this.m_queryClauses) {
            all.addAll(Arrays.asList(qc.getNamespacesInfo()));
        }
        return all.toArray(new PrefixAndNamespaceTuple[all.size()]);
    }

    public String toXML(XMLMarshaller m) throws Spml2Exception {
        return m.marshall(this);
    }

    public boolean isValid() {
        return true;
    }
}

