/*
 * Decompiled with CFR 0.152.
 */
package org.openspml.v2.msg.spmlbatch;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.openspml.v2.msg.PrefixAndNamespaceTuple;
import org.openspml.v2.msg.spml.BatchableRequest;
import org.openspml.v2.msg.spml.ExecutionMode;
import org.openspml.v2.msg.spml.Request;
import org.openspml.v2.msg.spmlbatch.NamespaceDefinitions;
import org.openspml.v2.msg.spmlbatch.OnError;
import org.openspml.v2.msg.spmlbatch.Processing;
import org.openspml.v2.util.xml.ArrayListWithType;
import org.openspml.v2.util.xml.ListWithType;

public class BatchRequest
extends Request {
    private static final String code_id = "$Id: BatchRequest.java,v 1.7 2006/08/30 18:02:59 kas Exp $";
    private ListWithType m_request = new ArrayListWithType(BatchableRequest.class);
    private Processing m_processing = Processing.SEQUENTIAL;
    private OnError m_onError = OnError.EXIT;

    public BatchRequest() {
    }

    public BatchRequest(String requestId, ExecutionMode executionMode, Processing processing, OnError onError) {
        super(requestId, executionMode);
        this.m_processing = processing;
        this.m_onError = onError;
    }

    public void addRequest(BatchableRequest req) {
        if (req != null) {
            this.m_request.add(req);
        }
    }

    public boolean removeRequest(BatchableRequest req) {
        return this.m_request.remove(req);
    }

    public void clearRequests() {
        this.m_request.clear();
    }

    public List getRequests() {
        return Collections.unmodifiableList(this.m_request);
    }

    public Processing getProcessing() {
        return this.m_processing;
    }

    public void setProcessing(Processing processing) {
        this.m_processing = processing;
    }

    public OnError getOnError() {
        return this.m_onError;
    }

    public void setOnError(OnError onError) {
        this.m_onError = onError;
    }

    public PrefixAndNamespaceTuple[] getNamespacesInfo() {
        PrefixAndNamespaceTuple[] supers = super.getNamespacesInfo();
        PrefixAndNamespaceTuple[] ours = PrefixAndNamespaceTuple.concatNamespacesInfo(supers, NamespaceDefinitions.getMarshallableNamespacesInfo());
        LinkedHashSet<Object> all = null;
        all = ours != null ? new LinkedHashSet<PrefixAndNamespaceTuple>(Arrays.asList(ours)) : new LinkedHashSet();
        if (this.m_request != null) {
            for (Request r : this.m_request) {
                PrefixAndNamespaceTuple[] rqni = r.getNamespacesInfo();
                if (rqni == null) continue;
                all.addAll(Arrays.asList(rqni));
            }
        }
        return all.toArray(new PrefixAndNamespaceTuple[all.size()]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BatchRequest)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BatchRequest batchRequest = (BatchRequest)o;
        if (this.m_onError != null ? !this.m_onError.equals(batchRequest.m_onError) : batchRequest.m_onError != null) {
            return false;
        }
        if (this.m_processing != null ? !this.m_processing.equals(batchRequest.m_processing) : batchRequest.m_processing != null) {
            return false;
        }
        return this.m_request.equals(batchRequest.m_request);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + this.m_request.hashCode();
        result = 29 * result + (this.m_processing != null ? this.m_processing.hashCode() : 0);
        result = 29 * result + (this.m_onError != null ? this.m_onError.hashCode() : 0);
        return result;
    }
}

