/*
 * Decompiled with CFR 0.152.
 */
package org.openspml.v2.msg.spml;

import java.net.URI;
import org.openspml.v2.msg.spml.CapabilitiesList;
import org.openspml.v2.msg.spml.Extensible;
import org.openspml.v2.msg.spml.Schema;
import org.openspml.v2.util.xml.ArrayListWithType;
import org.openspml.v2.util.xml.ListWithType;

public class Target
extends Extensible {
    private static final String code_id = "$Id: Target.java,v 1.4 2006/04/26 19:54:55 kas Exp $";
    private ListWithType m_schema = new ArrayListWithType(Schema.class);
    private CapabilitiesList m_capabilities = null;
    private String m_targetID = null;
    private URI m_profile = null;

    public Target() {
    }

    public Target(Schema[] schema, CapabilitiesList capabilities, String targetID, URI profile) {
        assert (schema != null);
        assert (schema.length > 0);
        for (int k = 0; k < schema.length; ++k) {
            assert (schema[k] != null);
            this.m_schema.add(schema[k]);
        }
        this.m_capabilities = capabilities;
        this.m_targetID = targetID;
        this.m_profile = profile;
    }

    public Schema[] getSchemas() {
        return this.m_schema.toArray(new Schema[this.m_schema.size()]);
    }

    public void addSchema(Schema schema) {
        assert (schema != null);
        this.m_schema.add(schema);
    }

    public boolean removeSchema(Schema schema) {
        assert (schema != null);
        return this.m_schema.remove(schema);
    }

    public void clearSchemas() {
        this.m_schema.clear();
    }

    public CapabilitiesList getCapabilities() {
        return this.m_capabilities;
    }

    public void setCapabilities(CapabilitiesList capabilities) {
        this.m_capabilities = capabilities;
    }

    public String getTargetID() {
        return this.m_targetID;
    }

    public void setTargetID(String targetID) {
        this.m_targetID = targetID;
    }

    public URI getProfile() {
        return this.m_profile;
    }

    public void setProfile(URI profile) {
        this.m_profile = profile;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Target)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Target target = (Target)o;
        if (this.m_capabilities != null ? !this.m_capabilities.equals(target.m_capabilities) : target.m_capabilities != null) {
            return false;
        }
        if (this.m_profile != null ? !this.m_profile.equals(target.m_profile) : target.m_profile != null) {
            return false;
        }
        if (!this.m_schema.equals(target.m_schema)) {
            return false;
        }
        return !(this.m_targetID != null ? !this.m_targetID.equals(target.m_targetID) : target.m_targetID != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + this.m_schema.hashCode();
        result = 29 * result + (this.m_capabilities != null ? this.m_capabilities.hashCode() : 0);
        result = 29 * result + (this.m_targetID != null ? this.m_targetID.hashCode() : 0);
        result = 29 * result + (this.m_profile != null ? this.m_profile.hashCode() : 0);
        return result;
    }
}

