/*
 * Decompiled with CFR 0.152.
 */
package org.openspml.v2.msg.spml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.openspml.v2.msg.BasicOpenContentAttr;
import org.openspml.v2.msg.OCEtoMarshallableAdapter;
import org.openspml.v2.msg.OpenContentAttr;
import org.openspml.v2.msg.OpenContentContainer;
import org.openspml.v2.msg.OpenContentElement;
import org.openspml.v2.msg.PrefixAndNamespaceTuple;
import org.openspml.v2.util.xml.BasicMarshallableElement;
import org.openspml.v2.util.xml.OperationalNameValuePair;

public class Extensible
extends BasicMarshallableElement
implements OpenContentContainer {
    private static final String code_id = "$Id: Extensible.java,v 1.9 2006/10/17 22:48:36 kas Exp $";
    private Set mOpenContentAttrs = new LinkedHashSet();
    private List mOpenContentElements = new ArrayList();

    public OperationalNameValuePair findOperationalAttrByName(String name) {
        return this.findOperationalNVPByName(name);
    }

    public OperationalNameValuePair findOperationalNVPByName(String name) {
        for (OpenContentElement ocEl : this.mOpenContentElements) {
            if (!(ocEl instanceof OperationalNameValuePair) || !((OperationalNameValuePair)ocEl).getName().equals(name)) continue;
            return (OperationalNameValuePair)ocEl;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeAllOperationalNVPsWithName(String name) {
        int removed = 0;
        ArrayList<OpenContentElement> newList = new ArrayList<OpenContentElement>();
        for (OpenContentElement ocEl : this.mOpenContentElements) {
            if (!(ocEl instanceof OperationalNameValuePair)) continue;
            if (((OperationalNameValuePair)ocEl).getName().equals(name)) {
                ++removed;
                continue;
            }
            newList.add(ocEl);
        }
        if (removed != 0) {
            Extensible extensible = this;
            synchronized (extensible) {
                this.mOpenContentElements = newList;
            }
        }
        return removed;
    }

    public void addOpenContentAttr(String name, String value) {
        this.addOpenContentAttr(new BasicOpenContentAttr(name, value));
    }

    public OpenContentAttr[] getOpenContentAttrs() {
        return this.mOpenContentAttrs.toArray(new OpenContentAttr[this.mOpenContentAttrs.size()]);
    }

    public String findOpenContentAttrValueByName(String name) {
        for (OpenContentAttr ocA : this.mOpenContentAttrs) {
            if (!ocA.getName().equals(name)) continue;
            return ocA.getValue();
        }
        return null;
    }

    public void addOpenContentElement(OpenContentElement obj) {
        assert (obj != null);
        this.mOpenContentElements.add(obj);
    }

    public OpenContentElement[] getOpenContentElements() {
        return this.mOpenContentElements.toArray(new OpenContentElement[this.mOpenContentElements.size()]);
    }

    public List getOpenContentElements(Class cls) {
        ArrayList<OpenContentElement> result = new ArrayList<OpenContentElement>();
        for (int k = 0; k < this.mOpenContentElements.size(); ++k) {
            OCEtoMarshallableAdapter adapter;
            OpenContentElement oce = (OpenContentElement)this.mOpenContentElements.get(k);
            if (oce.getClass().isAssignableFrom(cls)) {
                result.add(oce);
                continue;
            }
            if (!(oce instanceof OCEtoMarshallableAdapter) || !(adapter = (OCEtoMarshallableAdapter)oce).getAdaptedObject().getClass().isAssignableFrom(cls)) continue;
            result.add(adapter);
        }
        return result;
    }

    public PrefixAndNamespaceTuple[] getNamespacesInfo() {
        return new PrefixAndNamespaceTuple[]{new PrefixAndNamespaceTuple("spml", "urn:oasis:names:tc:SPML:2:0", true)};
    }

    public boolean isValid() {
        return true;
    }

    public void addOpenContentAttr(OpenContentAttr attribute) {
        assert (attribute != null);
        this.mOpenContentAttrs.add(attribute);
    }

    public boolean removeOpenContentAttr(OpenContentAttr attribute) {
        assert (attribute != null);
        return this.mOpenContentAttrs.remove(attribute);
    }

    public void setOpenContentElements(OpenContentElement[] elements) {
        this.mOpenContentElements.clear();
        if (elements != null && elements.length != 0) {
            this.mOpenContentElements.addAll(Arrays.asList(elements));
        }
    }

    public void setOpenContentAttrs(OpenContentAttr[] attrs) {
        this.mOpenContentAttrs.clear();
        if (attrs != null && attrs.length != 0) {
            this.mOpenContentAttrs.addAll(Arrays.asList(attrs));
        }
    }

    public void setOpenContent(OpenContentAttr[] attrs, OpenContentElement[] elements) {
        this.setOpenContentAttrs(attrs);
        this.setOpenContentElements(elements);
    }

    public boolean removeOpenContentElement(OpenContentElement obj) {
        assert (obj != null);
        return this.mOpenContentElements.remove(obj);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Extensible)) {
            return false;
        }
        Extensible extensible = (Extensible)o;
        if (this.mOpenContentAttrs != null ? !((Object)this.mOpenContentAttrs).equals(extensible.mOpenContentAttrs) : extensible.mOpenContentAttrs != null) {
            return false;
        }
        return !(this.mOpenContentElements != null ? !((Object)this.mOpenContentElements).equals(extensible.mOpenContentElements) : extensible.mOpenContentElements != null);
    }

    public int hashCode() {
        int result = this.mOpenContentAttrs != null ? ((Object)this.mOpenContentAttrs).hashCode() : 0;
        result = 29 * result + (this.mOpenContentElements != null ? ((Object)this.mOpenContentElements).hashCode() : 0);
        return result;
    }
}

