/*
 * Decompiled with CFR 0.152.
 */
package org.openspml.v2.msg.spml;

import java.net.URI;
import java.util.Arrays;
import org.openspml.v2.msg.spml.Extensible;
import org.openspml.v2.msg.spml.SchemaEntityRef;
import org.openspml.v2.util.xml.ArrayListWithType;
import org.openspml.v2.util.xml.ListWithType;

public class Capability
extends Extensible {
    private static final String code_id = "$Id: Capability.java,v 1.4 2006/04/25 21:22:09 kas Exp $";
    private ListWithType m_appliesTo = new ArrayListWithType(SchemaEntityRef.class);
    private URI m_namespaceURI = null;
    private URI m_location = null;

    public Capability() {
    }

    public Capability(SchemaEntityRef[] appliesTo, URI namespaceURI, URI location) {
        if (appliesTo != null) {
            this.m_appliesTo.addAll(Arrays.asList(appliesTo));
        }
        assert (namespaceURI != null);
        this.m_namespaceURI = namespaceURI;
        this.m_location = location;
    }

    public SchemaEntityRef[] getAppliesTo() {
        return this.m_appliesTo.toArray(new SchemaEntityRef[this.m_appliesTo.size()]);
    }

    public void addAppliesTo(SchemaEntityRef appliesTo) {
        assert (appliesTo != null);
        this.m_appliesTo.add(appliesTo);
    }

    public boolean removeAppliesTo(SchemaEntityRef appliesTo) {
        assert (appliesTo != null);
        return this.m_appliesTo.remove(appliesTo);
    }

    public void clearAppliesTo(SchemaEntityRef appliesTo) {
        this.m_appliesTo.clear();
    }

    public URI getNamespaceURI() {
        return this.m_namespaceURI;
    }

    public void setNamespaceURI(URI namespaceURI) {
        assert (namespaceURI != null);
        this.m_namespaceURI = namespaceURI;
    }

    public URI getLocation() {
        return this.m_location;
    }

    public void setLocation(URI location) {
        this.m_location = location;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Capability)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Capability capability = (Capability)o;
        if (this.m_appliesTo != null ? !this.m_appliesTo.equals(capability.m_appliesTo) : capability.m_appliesTo != null) {
            return false;
        }
        if (this.m_location != null ? !this.m_location.equals(capability.m_location) : capability.m_location != null) {
            return false;
        }
        return this.m_namespaceURI.equals(capability.m_namespaceURI);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.m_appliesTo != null ? this.m_appliesTo.hashCode() : 0);
        result = 29 * result + this.m_namespaceURI.hashCode();
        result = 29 * result + (this.m_location != null ? this.m_location.hashCode() : 0);
        return result;
    }
}

