/*
 * Decompiled with CFR 0.152.
 */
package org.openspml.v2.msg.spml;

import java.util.Arrays;
import org.openspml.v2.msg.spml.BatchableRequest;
import org.openspml.v2.msg.spml.CapabilityData;
import org.openspml.v2.msg.spml.ExecutionMode;
import org.openspml.v2.msg.spml.Extensible;
import org.openspml.v2.msg.spml.PSOIdentifier;
import org.openspml.v2.msg.spml.ReturnData;
import org.openspml.v2.util.xml.ArrayListWithType;
import org.openspml.v2.util.xml.ListWithType;

public class AddRequest
extends BatchableRequest {
    private static final String code_id = "$Id: AddRequest.java,v 1.6 2006/06/29 21:01:21 rfrech Exp $";
    private PSOIdentifier m_psoID = null;
    private PSOIdentifier m_containerID = null;
    private Extensible m_data = null;
    private ListWithType m_capabilityData = new ArrayListWithType(CapabilityData.class);
    private String m_targetId = null;
    private ReturnData m_returnData = ReturnData.EVERYTHING;

    public AddRequest() {
    }

    public AddRequest(String requestId, ExecutionMode executionMode, PSOIdentifier type, PSOIdentifier containerID, Extensible data, CapabilityData[] capabilityData, String targetId, ReturnData returnData) {
        super(requestId, executionMode);
        this.m_psoID = type;
        this.m_containerID = containerID;
        assert (data != null);
        this.m_data = data;
        if (capabilityData != null) {
            this.m_capabilityData.addAll(Arrays.asList(capabilityData));
        }
        this.m_targetId = targetId;
        this.m_returnData = returnData;
    }

    public PSOIdentifier getPsoID() {
        return this.m_psoID;
    }

    public void setPsoID(PSOIdentifier psoID) {
        this.m_psoID = psoID;
    }

    public PSOIdentifier getContainerID() {
        return this.m_containerID;
    }

    public void setContainerID(PSOIdentifier containerID) {
        this.m_containerID = containerID;
    }

    public Extensible getData() {
        return this.m_data;
    }

    public void setData(Extensible data) {
        assert (data != null);
        this.m_data = data;
    }

    public CapabilityData[] getCapabilityData() {
        return this.m_capabilityData.toArray(new CapabilityData[this.m_capabilityData.size()]);
    }

    public void addCapabilityData(CapabilityData capabilityData) {
        assert (capabilityData != null);
        this.m_capabilityData.add(capabilityData);
    }

    public boolean removeCapabilityData(CapabilityData capabilityData) {
        assert (capabilityData != null);
        return this.m_capabilityData.remove(capabilityData);
    }

    public void clearCapabilityData() {
        this.m_capabilityData.clear();
    }

    public String getTargetId() {
        return this.m_targetId;
    }

    public void setTargetId(String targetId) {
        this.m_targetId = targetId;
    }

    public ReturnData getReturnData() {
        return this.m_returnData;
    }

    public void setReturnData(ReturnData returnData) {
        this.m_returnData = returnData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AddRequest)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AddRequest addRequest = (AddRequest)o;
        if (!this.m_capabilityData.equals(addRequest.m_capabilityData)) {
            return false;
        }
        if (this.m_containerID != null ? !this.m_containerID.equals(addRequest.m_containerID) : addRequest.m_containerID != null) {
            return false;
        }
        if (!this.m_data.equals(addRequest.m_data)) {
            return false;
        }
        if (this.m_returnData != null ? !this.m_returnData.equals(addRequest.m_returnData) : addRequest.m_returnData != null) {
            return false;
        }
        if (this.m_targetId != null ? !this.m_targetId.equals(addRequest.m_targetId) : addRequest.m_targetId != null) {
            return false;
        }
        return !(this.m_psoID != null ? !this.m_psoID.equals(addRequest.m_psoID) : addRequest.m_psoID != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.m_psoID != null ? this.m_psoID.hashCode() : 0);
        result = 29 * result + (this.m_containerID != null ? this.m_containerID.hashCode() : 0);
        result = 29 * result + (this.m_data != null ? this.m_data.hashCode() : 0);
        result = 29 * result + this.m_capabilityData.hashCode();
        result = 29 * result + (this.m_targetId != null ? this.m_targetId.hashCode() : 0);
        result = 29 * result + (this.m_returnData != null ? this.m_returnData.hashCode() : 0);
        return result;
    }
}

