/*
 * Decompiled with CFR 0.152.
 */
package org.openspml.v2.msg;

import org.openspml.v2.msg.OpenContentElement;
import org.openspml.v2.msg.OpenContentElementAdapter;
import org.openspml.v2.util.Spml2Exception;

public class OCEtoXMLStringAdapter
implements OpenContentElementAdapter {
    private static final String code_id = "$Id: OCEtoXMLStringAdapter.java,v 1.6 2006/05/05 15:58:30 kas Exp $";
    private static final boolean COMMENT_STRINGS = true;
    private final String mXml;

    public OCEtoXMLStringAdapter(String xml) throws Spml2Exception {
        if (xml == null) {
            throw new Spml2Exception("Cannot adapt a null String as an OpenContentElement.");
        }
        this.mXml = xml;
    }

    public String getXMLString() {
        return this.mXml;
    }

    public Object getAdaptedObject() {
        return this.getXMLString();
    }

    public String toXML(int indent) throws Spml2Exception {
        return this.toXML();
    }

    public String toXML() throws Spml2Exception {
        String result = this.mXml;
        String begin = "<!-- Begin Adapted OpenContent String -->\n";
        String end = "<!-- End Adapted OpenContent String -->\n";
        result = begin + this.mXml + end;
        return result;
    }

    public OpenContentElement fromXML(Object xmlRep) throws Spml2Exception {
        if (xmlRep instanceof String) {
            return new OCEtoXMLStringAdapter((String)xmlRep);
        }
        throw new Spml2Exception("Expected a String as the xmlRep.");
    }
}

