/*
 * Decompiled with CFR 0.152.
 */
package org.openspml.v2.client;

import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.URL;
import org.openspml.v2.client.SimpleSOAPClient;
import org.openspml.v2.msg.spml.Request;
import org.openspml.v2.msg.spml.Response;
import org.openspml.v2.transport.RPCRouterMonitor;
import org.openspml.v2.util.Spml2Exception;
import org.openspml.v2.util.Spml2ExceptionWithResponse;
import org.openspml.v2.util.xml.ReflectiveDOMXMLUnmarshaller;
import org.openspml.v2.util.xml.ReflectiveXMLMarshaller;
import org.openspml.v2.util.xml.XmlUtil;

public class Spml2Client {
    public static final String code_id = "$Id: Spml2Client.java,v 1.8 2008/11/12 17:08:26 gh202020 Exp $";
    private String _action = null;
    private SimpleSOAPClientAdapter _client;
    private URL _url;
    private boolean _trace;

    public Spml2Client(String url) throws Spml2Exception {
        this(url, null);
    }

    public Spml2Client(String url, Authenticator authenticator) throws Spml2Exception {
        try {
            this.setUrl(url);
            this._client = new SimpleSOAPClientAdapter(new SimpleSOAPClient(authenticator));
        }
        catch (MalformedURLException e) {
            throw new Spml2Exception(e);
        }
    }

    private void setUrl(String s) throws MalformedURLException {
        this.setUrl(new URL(s));
    }

    private void setUrl(URL url) {
        this._url = url;
    }

    public void setHeader(String s) {
        this._client.setHeader(s);
    }

    public void setSOAPAction(String action) {
        this._action = action;
    }

    public void setBodyAttributes(String s) {
        this._client.setBodyAttributes(s);
    }

    public void setTrace(boolean b) {
        this._trace = b;
    }

    public void setMonitor(RPCRouterMonitor m) {
        this._client.setMonitor(m);
    }

    public void setReadTimeout(int timeout) {
        this._client.setReadTimeout(timeout);
    }

    public Response send(Request req) throws Spml2Exception, Spml2ExceptionWithResponse {
        ReflectiveXMLMarshaller marshaller = new ReflectiveXMLMarshaller();
        String requestXML = req.toXML(marshaller);
        String responseXML = this.send(requestXML);
        String payloadXML = XmlUtil.getSoapBodyContents(responseXML);
        ReflectiveDOMXMLUnmarshaller unmarshaller = new ReflectiveDOMXMLUnmarshaller();
        Response response = (Response)unmarshaller.unmarshall(payloadXML);
        this.throwErrors(response);
        return response;
    }

    public String sendRequest(Request req) throws Spml2Exception {
        String toSend = req.toXML(new ReflectiveXMLMarshaller());
        return this.send(toSend);
    }

    public String send(String xml) throws Spml2Exception {
        if (this._trace) {
            Spml2Client.println("SpmlClient: sending to " + this._url.toString());
            Spml2Client.println(xml);
        }
        xml = this._client.send(this._url, this._action, xml);
        if (this._trace) {
            Spml2Client.println("SpmlClient: received");
            Spml2Client.println(xml);
        }
        return xml;
    }

    public static void println(String msg) {
        System.out.println(msg);
    }

    public void throwErrors(Response res) throws Spml2ExceptionWithResponse {
        String[] msgs;
        if (res != null && (msgs = res.getErrorMessages()) != null && msgs.length != 0) {
            throw new Spml2ExceptionWithResponse(msgs[0], res);
        }
    }

    static class SimpleSOAPClientAdapter
    implements SOAPClientAdapter {
        private SimpleSOAPClient _client;

        SimpleSOAPClientAdapter(SimpleSOAPClient client) {
            this._client = client;
        }

        public void setHeader(String s) {
            this._client.setHeader(s);
        }

        public void setBodyAttributes(String s) {
            this._client.setBodyAttributes(s);
        }

        public void setMonitor(RPCRouterMonitor sm) {
            this._client.setMonitor(sm);
        }

        public void setReadTimeout(int timeout) {
            this._client.setReadTimeout(timeout);
        }

        public String send(URL url, String action, String xml) throws Spml2Exception {
            try {
                return this._client.sendAndReceive(url, action, xml);
            }
            catch (Exception e) {
                throw new Spml2Exception(e);
            }
        }
    }

    public static interface SOAPClientAdapter {
        public void setHeader(String var1);

        public void setBodyAttributes(String var1);

        public void setMonitor(RPCRouterMonitor var1);

        public String send(URL var1, String var2, String var3) throws Spml2Exception;
    }
}

