/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.controls;

import java.util.HashSet;
import java.util.Set;
import javax.naming.NamingException;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.ldap.message.InternalSearchRequest;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PagedSearchContext {
    private InternalSearchRequest previousSearchRequest;
    private int currentPosition;
    private byte[] cookie;
    private int cookieValue;
    private EntryFilteringCursor cursor;

    public PagedSearchContext(InternalSearchRequest searchRequest) {
        this.previousSearchRequest = searchRequest;
        this.currentPosition = 0;
        this.cookieValue = (int)(System.nanoTime() * 17L) + searchRequest.getMessageId();
        this.cookie = Value.getBytes((int)this.cookieValue);
    }

    public byte[] getCookie() {
        return this.cookie;
    }

    public int getCookieValue() {
        return this.cookieValue;
    }

    public byte[] getNewCookie() {
        this.cookieValue += (int)(System.nanoTime() * 17L);
        this.cookie = Value.getBytes((int)this.cookieValue);
        return this.cookie;
    }

    private Set<String> buildAttributeSet(InternalSearchRequest request, LdapSession session, AttributeTypeRegistry atRegistry) {
        HashSet<String> requestSet = new HashSet<String>();
        for (String attribute : request.getAttributes()) {
            try {
                AttributeType at = atRegistry.lookup(attribute);
                requestSet.add(at.getOid());
            }
            catch (NamingException ne) {
                if (!attribute.equals("+") && !attribute.equals("*") && !attribute.equals("1.1")) continue;
                requestSet.add(attribute);
            }
        }
        return requestSet;
    }

    public boolean hasSameRequest(InternalSearchRequest request, LdapSession session) {
        if (request.getScope() != this.previousSearchRequest.getScope()) {
            return false;
        }
        if (request.getSizeLimit() != this.previousSearchRequest.getSizeLimit()) {
            return false;
        }
        if (request.getTimeLimit() != this.previousSearchRequest.getTimeLimit()) {
            return false;
        }
        if (request.getTypesOnly() != this.previousSearchRequest.getTypesOnly()) {
            return false;
        }
        if (request.getDerefAliases() != this.previousSearchRequest.getDerefAliases()) {
            return false;
        }
        AttributeTypeRegistry atRegistry = session.getLdapServer().getDirectoryService().getRegistries().getAttributeTypeRegistry();
        if (request.getAttributes() == null) {
            if (this.previousSearchRequest.getAttributes() != null) {
                return false;
            }
        } else {
            if (this.previousSearchRequest.getAttributes() == null) {
                return false;
            }
            if (request.getAttributes().size() != this.previousSearchRequest.getAttributes().size()) {
                return false;
            }
            Set<String> requestSet = this.buildAttributeSet(request, session, atRegistry);
            Set<String> previousRequestSet = this.buildAttributeSet(this.previousSearchRequest, session, atRegistry);
            if (requestSet.size() != previousRequestSet.size()) {
                return false;
            }
            for (String attribute : requestSet) {
                previousRequestSet.remove(attribute);
            }
            if (!previousRequestSet.isEmpty()) {
                return false;
            }
        }
        try {
            request.getBase().normalize(atRegistry.getNormalizerMapping());
            if (!this.previousSearchRequest.getBase().isNormalized()) {
                this.previousSearchRequest.getBase().normalize(atRegistry.getNormalizerMapping());
            }
            if (!request.getBase().equals((Object)this.previousSearchRequest.getBase())) {
                return false;
            }
        }
        catch (NamingException ne) {
            return false;
        }
        return true;
    }

    public int getCurrentPosition() {
        return this.currentPosition;
    }

    public void incrementCurrentPosition(int returnedEntries) {
        this.currentPosition += returnedEntries;
    }

    public InternalSearchRequest getPreviousSearchRequest() {
        return this.previousSearchRequest;
    }

    public EntryFilteringCursor getCursor() {
        return this.cursor;
    }

    public void setCursor(EntryFilteringCursor cursor) {
        this.cursor = cursor;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PagedSearch context : <");
        sb.append(StringTools.dumpBytes((byte[])this.cookie));
        sb.append(", ");
        sb.append(this.currentPosition);
        sb.append(">");
        return sb.toString();
    }
}

