/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.bind.gssapi;

import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslServer;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionType;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntry;
import org.apache.directory.server.kerberos.shared.store.operations.GetPrincipal;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.bind.AbstractMechanismHandler;
import org.apache.directory.server.ldap.handlers.bind.gssapi.GssapiCallbackHandler;
import org.apache.directory.server.protocol.shared.ServiceConfigurationException;
import org.apache.directory.shared.ldap.message.InternalBindRequest;
import org.apache.directory.shared.ldap.name.LdapDN;

public class GssapiMechanismHandler
extends AbstractMechanismHandler {
    public SaslServer handleMechanism(LdapSession ldapSession, InternalBindRequest bindRequest) throws Exception {
        SaslServer ss = (SaslServer)ldapSession.getSaslProperty("saslServer");
        if (ss == null) {
            Subject subject = this.getSubject(ldapSession.getLdapServer());
            final String saslHost = (String)ldapSession.getSaslProperty("host");
            final Map saslProps = (Map)ldapSession.getSaslProperty("saslProps");
            CoreSession adminSession = ldapSession.getLdapServer().getDirectoryService().getAdminSession();
            final GssapiCallbackHandler callbackHandler = new GssapiCallbackHandler(ldapSession, adminSession, bindRequest);
            ss = Subject.doAs(subject, new PrivilegedExceptionAction<SaslServer>(){

                @Override
                public SaslServer run() throws Exception {
                    return Sasl.createSaslServer("GSSAPI", "ldap", saslHost, saslProps, callbackHandler);
                }
            });
            ldapSession.putSaslProperty("saslServer", ss);
        }
        return ss;
    }

    public void init(LdapSession ldapSession) {
        String saslHost = ldapSession.getLdapServer().getSaslHost();
        ldapSession.putSaslProperty("host", saslHost);
        HashMap<String, String> saslProps = new HashMap<String, String>();
        saslProps.put("javax.security.sasl.qop", ldapSession.getLdapServer().getSaslQopString());
        ldapSession.putSaslProperty("saslProps", saslProps);
    }

    public void cleanup(LdapSession ldapSession) {
        this.insertSaslFilter(ldapSession);
        ldapSession.removeSaslProperty("host");
        ldapSession.removeSaslProperty("userBaseDn");
        ldapSession.removeSaslProperty("saslMech");
        ldapSession.removeSaslProperty("saslProps");
        ldapSession.removeSaslProperty("saslAuthentUser");
    }

    private Subject getSubject(LdapServer ldapServer) throws Exception {
        String servicePrincipalName = ldapServer.getSaslPrincipal();
        KerberosPrincipal servicePrincipal = new KerberosPrincipal(servicePrincipalName);
        GetPrincipal getPrincipal = new GetPrincipal(servicePrincipal);
        PrincipalStoreEntry entry = null;
        try {
            entry = this.findPrincipal(ldapServer, getPrincipal);
        }
        catch (ServiceConfigurationException sce) {
            String message = "Service principal " + servicePrincipalName + " not found at search base DN " + ldapServer.getSearchBaseDn() + ".";
            throw new ServiceConfigurationException(message, (Throwable)sce);
        }
        if (entry == null) {
            String message = "Service principal " + servicePrincipalName + " not found at search base DN " + ldapServer.getSearchBaseDn() + ".";
            throw new ServiceConfigurationException(message);
        }
        Subject subject = new Subject();
        for (EncryptionType encryptionType : entry.getKeyMap().keySet()) {
            EncryptionKey key = (EncryptionKey)entry.getKeyMap().get(encryptionType);
            byte[] keyBytes = key.getKeyValue();
            int type = key.getKeyType().getOrdinal();
            int kvno = key.getKeyVersion();
            KerberosKey serviceKey = new KerberosKey(servicePrincipal, keyBytes, type, kvno);
            subject.getPrivateCredentials().add(serviceKey);
        }
        return subject;
    }

    private PrincipalStoreEntry findPrincipal(LdapServer ldapServer, GetPrincipal getPrincipal) throws Exception {
        CoreSession adminSession = ldapServer.getDirectoryService().getAdminSession();
        return (PrincipalStoreEntry)getPrincipal.execute(adminSession, new LdapDN(ldapServer.getSearchBaseDn()));
    }
}

