/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers;

import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.LdapRequestHandler;
import org.apache.directory.shared.ldap.message.InternalLdapResult;
import org.apache.directory.shared.ldap.message.InternalModifyDnRequest;
import org.apache.directory.shared.ldap.message.InternalResultResponseRequest;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyDnHandler
extends LdapRequestHandler<InternalModifyDnRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(ModifyDnHandler.class);

    @Override
    public void handle(LdapSession session, InternalModifyDnRequest req) {
        InternalLdapResult result = req.getResultResponse().getLdapResult();
        LOG.debug("Handling modify dn request while ignoring referrals: {}", (Object)req);
        if (req.getName().isEmpty()) {
            String msg = "Modify DN is not allowed on Root DSE.";
            result.setResultCode(ResultCodeEnum.PROTOCOL_ERROR);
            result.setErrorMessage(msg);
            session.getIoSession().write((Object)req.getResultResponse());
            return;
        }
        try {
            LdapDN newRdn = new LdapDN(req.getNewRdn().toString());
            newRdn.normalize(session.getCoreSession().getDirectoryService().getRegistries().getAttributeTypeRegistry().getNormalizerMapping());
            LdapDN oldRdn = new LdapDN(req.getName().getRdn().toString());
            oldRdn.normalize(session.getCoreSession().getDirectoryService().getRegistries().getAttributeTypeRegistry().getNormalizerMapping());
            boolean rdnChanged = req.getNewRdn() != null && !newRdn.getNormName().equals(oldRdn.getNormName());
            CoreSession coreSession = session.getCoreSession();
            if (rdnChanged) {
                if (req.getNewSuperior() != null) {
                    coreSession.moveAndRename(req);
                } else {
                    coreSession.rename(req);
                }
            } else if (req.getNewSuperior() != null) {
                req.setNewRdn(null);
                coreSession.move(req);
            } else {
                result.setErrorMessage("Attempt to move entry onto itself.");
                result.setResultCode(ResultCodeEnum.ENTRY_ALREADY_EXISTS);
                result.setMatchedDn(req.getName());
                session.getIoSession().write((Object)req.getResultResponse());
                return;
            }
            result.setResultCode(ResultCodeEnum.SUCCESS);
            session.getIoSession().write((Object)req.getResultResponse());
        }
        catch (Exception e) {
            this.handleException(session, (InternalResultResponseRequest)req, e);
        }
    }
}

