/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.ssl;

import edu.vt.middleware.ldap.props.SimplePropertyInvoker;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CredentialConfigParser {
    private static final Pattern FULL_CONFIG_PATTERN = Pattern.compile("([^\\{]+)\\s*\\{\\s*([^\\{]+)\\s*\\{\\s*(.*)\\}\\s*\\}\\s*");
    private static final Pattern CREDENTIAL_ONLY_CONFIG_PATTERN = Pattern.compile("\\s*\\{\\s*([^\\{]+)\\s*\\{\\s*(.*)\\}\\s*\\}\\s*");
    private static final Pattern PARAMS_ONLY_CONFIG_PATTERN = Pattern.compile("\\s*\\{\\s*(.*)\\s*\\}\\s*");
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("([^\\}\\{])+");
    private String sslSocketFactoryClassName = "edu.vt.middleware.ldap.ssl.TLSSocketFactory";
    private String credentialConfigClassName = "edu.vt.middleware.ldap.ssl.X509CredentialConfig";
    private Map<String, String> properties = new HashMap<String, String>();

    public CredentialConfigParser(String config) {
        int i;
        Matcher fullMatcher = FULL_CONFIG_PATTERN.matcher(config);
        Matcher credentialOnlyMatcher = CREDENTIAL_ONLY_CONFIG_PATTERN.matcher(config);
        Matcher paramsOnlyMatcher = PARAMS_ONLY_CONFIG_PATTERN.matcher(config);
        Matcher m = null;
        if (fullMatcher.matches()) {
            i = 1;
            this.sslSocketFactoryClassName = fullMatcher.group(i++).trim();
            this.credentialConfigClassName = fullMatcher.group(i++).trim();
            if (!"".equals(fullMatcher.group(i).trim())) {
                m = PROPERTY_PATTERN.matcher(fullMatcher.group(i).trim());
            }
        } else if (credentialOnlyMatcher.matches()) {
            i = 1;
            this.credentialConfigClassName = credentialOnlyMatcher.group(i++).trim();
            if (!"".equals(credentialOnlyMatcher.group(i).trim())) {
                m = PROPERTY_PATTERN.matcher(credentialOnlyMatcher.group(i).trim());
            }
        } else if (paramsOnlyMatcher.matches()) {
            i = 1;
            if (!"".equals(paramsOnlyMatcher.group(1).trim())) {
                m = PROPERTY_PATTERN.matcher(paramsOnlyMatcher.group(1).trim());
            }
        }
        if (m != null) {
            while (m.find()) {
                String input = m.group().trim();
                if (input == null || "".equals(input)) continue;
                String[] s = input.split("=");
                this.properties.put(s[0].trim(), s[1].trim());
            }
        }
    }

    public String getSslSocketFactoryClassName() {
        return this.sslSocketFactoryClassName;
    }

    public String getCredentialConfigClassName() {
        return this.credentialConfigClassName;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public static boolean isCredentialConfig(String config) {
        return FULL_CONFIG_PATTERN.matcher(config).matches() || CREDENTIAL_ONLY_CONFIG_PATTERN.matcher(config).matches() || PARAMS_ONLY_CONFIG_PATTERN.matcher(config).matches();
    }

    public Object initializeType() {
        Class<?> c = SimplePropertyInvoker.createClass(this.getCredentialConfigClassName());
        Class<?> o = SimplePropertyInvoker.instantiateType(c, this.getCredentialConfigClassName());
        this.setProperties(c, o);
        return o;
    }

    protected void setProperties(Class<?> c, Object o) {
        SimplePropertyInvoker invoker = new SimplePropertyInvoker(c);
        for (Map.Entry<String, String> entry : this.getProperties().entrySet()) {
            invoker.setProperty(o, entry.getKey(), entry.getValue());
        }
    }
}

