/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.servlets;

import edu.vt.middleware.ldap.servlets.session.SessionManager;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommonServlet
extends HttpServlet {
    private static final long serialVersionUID = -2580419817969949661L;
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected SessionManager sessionManager;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String sessionManagerClass = this.getInitParameter("edu.vt.middleware.ldap.servlets.sessionManager");
        if (sessionManagerClass == null) {
            sessionManagerClass = "edu.vt.middleware.ldap.servlets.session.DefaultSessionManager";
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("edu.vt.middleware.ldap.servlets.sessionManager = " + sessionManagerClass));
        }
        try {
            this.sessionManager = (SessionManager)Class.forName(sessionManagerClass).newInstance();
        }
        catch (ClassNotFoundException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error((Object)("Could not find class " + sessionManagerClass), (Throwable)e);
            }
            throw new ServletException((Throwable)e);
        }
        catch (InstantiationException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error((Object)("Could not instantiate class " + sessionManagerClass), (Throwable)e);
            }
            throw new ServletException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error((Object)("Could not access class " + sessionManagerClass), (Throwable)e);
            }
            throw new ServletException((Throwable)e);
        }
        String sessionId = this.getInitParameter("edu.vt.middleware.ldap.servlets.sessionId");
        if (sessionId == null) {
            sessionId = "user";
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("edu.vt.middleware.ldap.servlets.sessionId = " + sessionId));
        }
        this.sessionManager.setSessionId(sessionId);
        String invalidateSession = this.getInitParameter("edu.vt.middleware.ldap.servlets.invalidateSession");
        if (invalidateSession == null) {
            invalidateSession = "true";
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("edu.vt.middleware.ldap.servlets.invalidateSession = " + invalidateSession));
        }
        this.sessionManager.setInvalidateSession(Boolean.valueOf(invalidateSession));
    }
}

