/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.props;

import edu.vt.middleware.ldap.props.SimplePropertyInvoker;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigParser {
    private static final Pattern CONFIG_PATTERN = Pattern.compile("([^\\{]+)\\s*\\{(.*)\\}\\s*");
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("([^\\}\\{])+");
    private String className;
    private Map<String, String> properties = new HashMap<String, String>();

    public ConfigParser(String config) {
        Matcher matcher = CONFIG_PATTERN.matcher(config);
        if (matcher.matches()) {
            this.className = matcher.group(1).trim();
            String props = matcher.group(2).trim();
            Matcher m = PROPERTY_PATTERN.matcher(props);
            while (m.find()) {
                String input = m.group().trim();
                if (input == null || "".equals(input)) continue;
                String[] s = input.split("=");
                this.properties.put(s[0].trim(), s[1].trim());
            }
        }
    }

    public String getClassName() {
        return this.className;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public static boolean isConfig(String config) {
        return CONFIG_PATTERN.matcher(config).matches();
    }

    public Object initializeType() {
        Class<?> c = SimplePropertyInvoker.createClass(this.getClassName());
        Class<?> o = SimplePropertyInvoker.instantiateType(c, this.getClassName());
        this.setProperties(c, o);
        return o;
    }

    protected void setProperties(Class<?> c, Object o) {
        SimplePropertyInvoker invoker = new SimplePropertyInvoker(c);
        for (Map.Entry<String, String> entry : this.getProperties().entrySet()) {
            invoker.setProperty(o, entry.getKey(), entry.getValue());
        }
    }
}

