/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.props;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPropertyInvoker {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected Class<?> clazz;
    protected final Map<String, Method[]> properties = new HashMap<String, Method[]>();

    protected void initialize(Class<?> c, String domain) {
        for (Method setterMethod : c.getMethods()) {
            if (!setterMethod.getName().startsWith("set") || setterMethod.getParameterTypes().length != 1) continue;
            String mName = setterMethod.getName().substring("set".length());
            try {
                Method getterMethod = c.getMethod("get" + mName, new Class[0]);
                StringBuffer pName = new StringBuffer(domain);
                pName.append(mName.substring(0, 1).toLowerCase());
                pName.append(mName.substring(1, mName.length()));
                this.properties.put(pName.toString(), new Method[]{getterMethod, setterMethod});
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        this.clazz = c;
    }

    public void setProperty(Object object, String name, String value) {
        Method setter;
        Method getter;
        if (!this.clazz.isInstance(object)) {
            throw new IllegalArgumentException("Illegal attempt to set property for class " + this.clazz.getName() + " on object of type " + object.getClass().getName());
        }
        Method method = getter = this.properties.get(name) != null ? this.properties.get(name)[0] : null;
        if (getter == null) {
            throw new IllegalArgumentException("No getter method found for " + name + " on object " + this.clazz.getName());
        }
        Method method2 = setter = this.properties.get(name) != null ? this.properties.get(name)[1] : null;
        if (setter == null) {
            throw new IllegalArgumentException("No setter method found for " + name + " on object " + this.clazz.getName());
        }
        AbstractPropertyInvoker.invokeMethod(setter, object, this.convertValue(getter.getReturnType(), value));
    }

    protected abstract Object convertValue(Class<?> var1, String var2);

    public boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    public String[] getProperties() {
        return this.properties.keySet().toArray(new String[0]);
    }

    public static <T> T instantiateType(T type, String className) {
        try {
            return (T)AbstractPropertyInvoker.createClass(className).newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Class<?> createClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not find class '" + className + "'", e);
        }
    }

    public static Object invokeMethod(Method method, Object object, Object arg) {
        try {
            Object[] params = new Object[]{arg};
            if (arg == null && method.getParameterTypes().length == 0) {
                params = null;
            }
            return method.invoke(object, params);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

