/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.pool;

import edu.vt.middleware.ldap.Ldap;
import edu.vt.middleware.ldap.SearchFilter;
import edu.vt.middleware.ldap.pool.LdapValidator;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareLdapValidator
implements LdapValidator<Ldap> {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String validateDn = "";
    private SearchFilter validateFilter = new SearchFilter("(objectClass=*)");

    public CompareLdapValidator() {
    }

    public CompareLdapValidator(String dn, SearchFilter filter) {
        this.validateDn = dn;
        this.validateFilter = filter;
    }

    public String getValidateDn() {
        return this.validateDn;
    }

    public SearchFilter getValidateFilter() {
        return this.validateFilter;
    }

    public void setValidateDn(String s) {
        this.validateDn = s;
    }

    public void setValidateFilter(SearchFilter filter) {
        this.validateFilter = filter;
    }

    @Override
    public boolean validate(Ldap l) {
        boolean success;
        block3: {
            success = false;
            if (l != null) {
                try {
                    success = l.compare(this.validateDn, this.validateFilter);
                }
                catch (NamingException e) {
                    if (!this.logger.isDebugEnabled()) break block3;
                    this.logger.debug((Object)("validation failed for compare " + this.validateFilter), (Throwable)e);
                }
            }
        }
        return success;
    }
}

