/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.handler;

import edu.vt.middleware.ldap.LdapConfig;
import edu.vt.middleware.ldap.handler.AbstractConnectionHandler;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;

public class DefaultConnectionHandler
extends AbstractConnectionHandler {
    public DefaultConnectionHandler() {
    }

    public DefaultConnectionHandler(LdapConfig lc) {
        this.setLdapConfig(lc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(String dn, Object credential) throws NamingException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Bind with the following parameters:");
            this.logger.debug((Object)("  dn = " + dn));
            if (this.config.getLogCredentials()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("  credential = " + credential));
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"  credential = <suppressed>");
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("  config = " + this.config.getEnvironment()));
            }
        }
        Hashtable environment = new Hashtable(this.config.getEnvironment());
        environment.put("java.naming.security.authentication", this.config.getAuthtype());
        if (dn != null) {
            environment.put("java.naming.security.principal", dn);
            if (credential != null) {
                environment.put("java.naming.security.credentials", credential);
            }
        }
        try {
            this.context = new InitialLdapContext(environment, null);
        }
        catch (NamingException e) {
            if (this.context != null) {
                try {
                    this.context.close();
                }
                finally {
                    this.context = null;
                }
            }
            throw e;
        }
    }

    public DefaultConnectionHandler newInstance() {
        return new DefaultConnectionHandler(this.config);
    }
}

