/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.dsml;

import edu.vt.middleware.ldap.bean.LdapBeanFactory;
import edu.vt.middleware.ldap.bean.LdapBeanProvider;
import edu.vt.middleware.ldap.bean.LdapResult;
import edu.vt.middleware.ldap.dsml.Dsmlv1;
import edu.vt.middleware.ldap.dsml.Dsmlv2;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.DocumentException;

public class DsmlResultConverter {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected LdapBeanFactory beanFactory = LdapBeanProvider.getLdapBeanFactory();
    private Dsmlv1 dsmlv1 = new Dsmlv1();
    private Dsmlv2 dsmlv2 = new Dsmlv2();

    public LdapBeanFactory getLdapBeanFactory() {
        return this.beanFactory;
    }

    public void setLdapBeanFactory(LdapBeanFactory lbf) {
        if (lbf != null) {
            this.beanFactory = lbf;
            this.dsmlv1.setLdapBeanFactory(lbf);
            this.dsmlv2.setLdapBeanFactory(lbf);
        }
    }

    public String toDsmlv1(LdapResult result) {
        StringWriter writer;
        block2: {
            writer = new StringWriter();
            try {
                this.dsmlv1.outputDsml(result.toSearchResults().iterator(), (Writer)writer);
            }
            catch (IOException e) {
                if (!this.logger.isWarnEnabled()) break block2;
                this.logger.warn((Object)"Could not write dsml to StringWriter", (Throwable)e);
            }
        }
        return writer.toString();
    }

    public LdapResult fromDsmlv1(String dsml) throws DocumentException {
        LdapResult result;
        block4: {
            result = this.beanFactory.newLdapResult();
            try {
                result.addEntries(this.dsmlv1.importDsml(new StringReader(dsml)));
            }
            catch (IOException e) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)"Could not read dsml from StringReader", (Throwable)e);
                }
            }
            catch (NamingException e) {
                if (!this.logger.isErrorEnabled()) break block4;
                this.logger.error((Object)"Unexpected naming exception occurred", (Throwable)e);
            }
        }
        return result;
    }

    public String toDsmlv2(LdapResult result) {
        StringWriter writer;
        block2: {
            writer = new StringWriter();
            try {
                this.dsmlv2.outputDsml(result.toSearchResults().iterator(), (Writer)writer);
            }
            catch (IOException e) {
                if (!this.logger.isWarnEnabled()) break block2;
                this.logger.warn((Object)"Could not write dsml to StringWriter", (Throwable)e);
            }
        }
        return writer.toString();
    }

    public LdapResult fromDsmlv2(String dsml) throws DocumentException {
        LdapResult result;
        block4: {
            result = this.beanFactory.newLdapResult();
            try {
                result.addEntries(this.dsmlv2.importDsml(new StringReader(dsml)));
            }
            catch (IOException e) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)"Could not read dsml from StringReader", (Throwable)e);
                }
            }
            catch (NamingException e) {
                if (!this.logger.isErrorEnabled()) break block4;
                this.logger.error((Object)"Unexpected naming exception occurred", (Throwable)e);
            }
        }
        return result;
    }
}

