/*
 * Decompiled with CFR 0.152.
 */
package com.p6spy.engine.common;

import com.p6spy.engine.common.KeyValue;
import com.p6spy.engine.common.P6LogQuery;
import com.p6spy.engine.common.P6SpyOptions;
import java.beans.IntrospectionException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;

public class P6Util {
    static /* synthetic */ Class class$com$p6spy$engine$common$P6Util;
    static /* synthetic */ Class class$java$lang$String;

    public static int parseInt(String i, int defaultValue) {
        if (i == null || i.equals("")) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(i);
        }
        catch (NumberFormatException nfe) {
            P6LogQuery.logError("NumberFormatException occured parsing value " + i);
            return defaultValue;
        }
    }

    public static long parseLong(String l, long defaultValue) {
        if (l == null || l.equals("")) {
            return defaultValue;
        }
        try {
            return Long.parseLong(l);
        }
        catch (NumberFormatException nfe) {
            P6LogQuery.logError("NumberFormatException occured parsing value " + l);
            return defaultValue;
        }
    }

    public static boolean isTrue(String s, boolean defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        return s.equals("1") || s.trim().equalsIgnoreCase("true");
    }

    public static int atoi(Object s) {
        int i;
        block3: {
            i = 0;
            if (s == null) break block3;
            String n = s.toString();
            int dot = n.indexOf(46);
            if (dot != -1) {
                n = n.substring(0, dot);
            }
            try {
                i = new Integer(n);
            }
            catch (NumberFormatException e) {
                i = 0;
            }
        }
        return i;
    }

    public static Properties loadProperties(String file) {
        Properties props;
        block4: {
            props = new Properties();
            try {
                String path = P6Util.classPathFile(file);
                if (path == null) {
                    P6LogQuery.logError("Can't find " + file + ". " + P6Util.getCheckedPath());
                    break block4;
                }
                FileInputStream in = new FileInputStream(path);
                props.load(in);
                in.close();
            }
            catch (FileNotFoundException e1) {
                P6LogQuery.logError("File not found " + file + " " + e1);
            }
            catch (IOException e2) {
                P6LogQuery.logError("IO Error reading file " + file + " " + e2);
            }
        }
        return props;
    }

    protected static void removeDots(Properties props) {
        Enumeration<Object> keys = props.keys();
        HashMap<String, String> hash = new HashMap<String, String>();
        boolean done = false;
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (key.indexOf(46) == -1) continue;
            int len = key.length();
            int newLen = 0;
            char[] car = new char[len];
            int i = 0;
            while (i < len) {
                char c = key.charAt(i);
                if (c != '.') {
                    car[newLen++] = c;
                }
                ++i;
            }
            String out = new String(car, 0, newLen);
            hash.put(out, props.getProperty(key));
        }
        if (done) {
            props.putAll((Map<?, ?>)hash);
        }
    }

    protected static String getCheckedPath() {
        String checkedPath = "\n\nClassloader via thread: <" + P6Util.getClassPathAsString(Thread.currentThread().getContextClassLoader()) + ">\n\n";
        checkedPath = checkedPath + "Classloader via Class: <" + P6Util.getClassPathAsString((class$com$p6spy$engine$common$P6Util == null ? (class$com$p6spy$engine$common$P6Util = P6Util.class$("com.p6spy.engine.common.P6Util")) : class$com$p6spy$engine$common$P6Util).getClassLoader()) + ">\n\n";
        checkedPath = checkedPath + "java.class.path: <" + System.getProperty("java.class.path") + ">\n\n";
        return checkedPath;
    }

    protected static String getClassPathAsString(ClassLoader classLoader) {
        String path = "";
        try {
            URL[] urls = ((URLClassLoader)classLoader).getURLs();
            int i = 0;
            while (i < urls.length) {
                if (path != "") {
                    path = path + ";";
                }
                path = path + urls[i].toString();
                ++i;
            }
        }
        catch (ClassCastException e) {}
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static ArrayList loadProperties(String file, String prefix) {
        ArrayList<KeyValue> props = new ArrayList<KeyValue>();
        InputStreamReader in = null;
        BufferedReader reader = null;
        try {
            String path = P6Util.classPathFile(file);
            if (path == null) {
                P6LogQuery.logError("Can't find " + file + ". " + P6Util.getCheckedPath());
            } else {
                String line;
                in = new FileReader(path);
                reader = new BufferedReader(in);
                while ((line = reader.readLine()) != null) {
                    void var6_8;
                    if (!var6_8.trim().startsWith(prefix)) continue;
                    StringTokenizer st = new StringTokenizer((String)var6_8, "=");
                    try {
                        String name = st.nextToken();
                        String value = st.nextToken();
                        KeyValue kv = new KeyValue(name.trim(), value.trim());
                        props.add(kv);
                    }
                    catch (NoSuchElementException e) {
                        // empty catch block
                    }
                }
            }
        }
        catch (FileNotFoundException e1) {
            P6LogQuery.logError("File not found " + file + " " + e1);
        }
        catch (IOException e2) {
            P6LogQuery.logError("IO Error reading file " + file + " " + e2);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {}
        }
        return props;
    }

    public static ArrayList reverseArrayList(ArrayList arraylist) {
        ArrayList newlist = new ArrayList(arraylist.size());
        int i = arraylist.size() - 1;
        while (i >= 0) {
            newlist.add(arraylist.get(i));
            --i;
        }
        return newlist;
    }

    public static String classPathFile(String file) {
        String dir;
        File fp = null;
        String path = null;
        String separator = System.getProperty("path.separator");
        String slash = System.getProperty("file.separator");
        String classpath = "." + separator + System.getProperty("java.class.path");
        String local = System.getProperty("p6.home");
        try {
            if (local != null) {
                fp = new File(local, file);
            } else {
                fp = P6Util.classLoadPropertyFile(Thread.currentThread().getContextClassLoader().getResource(file));
                if (fp == null) {
                    fp = P6Util.classLoadPropertyFile((class$com$p6spy$engine$common$P6Util == null ? (class$com$p6spy$engine$common$P6Util = P6Util.class$("com.p6spy.engine.common.P6Util")) : class$com$p6spy$engine$common$P6Util).getClassLoader().getResource(file));
                }
                if (fp == null) {
                    P6Util.classLoadPropertyFile(ClassLoader.getSystemResource(file));
                }
            }
            if (fp.exists()) {
                return fp.getCanonicalPath();
            }
        }
        catch (Exception exc) {
            // empty catch block
        }
        StringTokenizer tok = new StringTokenizer(classpath, separator);
        while (!(fp = new File(path = (dir = tok.nextToken()).equals(".") ? file : dir + slash + file)).exists() && tok.hasMoreTokens()) {
        }
        return fp.exists() ? path : null;
    }

    public static File classLoadPropertyFile(URL purl) {
        try {
            if (purl != null) {
                return new File(purl.getPath());
            }
        }
        catch (Exception e) {}
        return null;
    }

    public static Date timeNow() {
        return new Date();
    }

    public static PrintStream getPrintStream(String file, boolean append) throws IOException {
        PrintStream stream = null;
        FileOutputStream fw = new FileOutputStream(file, append);
        stream = new PrintStream(fw, P6SpyOptions.getAutoflush());
        return stream;
    }

    public static String timeTaken(Date start, String msg) {
        double t = (double)P6Util.elapsed(start) / 1000.0;
        return "Time: " + msg + ": " + t;
    }

    public static long elapsed(Date start) {
        return start == null ? 0L : P6Util.timeNow().getTime() - start.getTime();
    }

    public static Class forName(String name) throws ClassNotFoundException {
        ClassLoader ctxLoader = null;
        try {
            ctxLoader = Thread.currentThread().getContextClassLoader();
            return Class.forName(name, true, ctxLoader);
        }
        catch (ClassNotFoundException ex) {
        }
        catch (SecurityException ex) {
        }
        return Class.forName(name);
    }

    public static void dynamicSet(Class klass, String property, String value) {
        try {
            P6Util.set(klass, property, new String[]{value});
        }
        catch (IntrospectionException e) {
            P6LogQuery.logError("Could not set property " + property + " due to IntrospectionException");
        }
        catch (IllegalAccessException e) {
            P6LogQuery.logError("Could not set property " + property + " due to IllegalAccessException");
        }
        catch (NoSuchMethodException e) {
        }
        catch (InvocationTargetException e) {
            P6LogQuery.logError("Could not set property " + property + " due to InvoicationTargetException");
        }
    }

    public static void set(Class klass, String method, Object[] args) throws IntrospectionException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Method m = klass.getDeclaredMethod(method, class$java$lang$String == null ? (class$java$lang$String = P6Util.class$("java.lang.String")) : class$java$lang$String);
        m.invoke(null, args);
    }

    public static String dynamicGet(Class klass, String property) {
        try {
            Object value = P6Util.get(klass, property);
            return value == null ? null : value.toString();
        }
        catch (IntrospectionException e) {
            P6LogQuery.logError("Could not get property " + property + " due to IntrospectionException");
        }
        catch (IllegalAccessException e) {
            P6LogQuery.logError("Could not get property " + property + " due to IllegalAccessException");
        }
        catch (NoSuchMethodException e) {
            P6LogQuery.logError("Could not get property " + property + " due to NoSuchMethodException");
        }
        catch (InvocationTargetException e) {
            P6LogQuery.logError("Could not get property " + property + " due to InvoicationTargetException");
        }
        return null;
    }

    public static Object get(Class klass, String method) throws IntrospectionException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Method m = klass.getDeclaredMethod(method, null);
        return m.invoke(null, null);
    }

    public static Collection dynamicGetOptions(Class klass) {
        try {
            return P6Util.findAllMethods(klass);
        }
        catch (IntrospectionException e) {
            P6LogQuery.logError("Could not get options list due to IntrospectionException");
            return null;
        }
    }

    public static ArrayList findAllMethods(Class klass) throws IntrospectionException {
        ArrayList<String> list = new ArrayList<String>();
        Method[] methods = klass.getDeclaredMethods();
        int i = 0;
        while (methods != null && i < methods.length) {
            Method method = methods[i];
            String methodName = method.getName();
            if (methodName.startsWith("get")) {
                list.add(methodName);
            }
            ++i;
        }
        return list;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

