/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.util;

import java.util.HashMap;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.Label;
import org.objectweb.asm.util.ASMifierClassVisitor;
import org.objectweb.asm.util.PrintCodeVisitor;
import org.objectweb.asm.util.attrs.ASMifiable;

public class ASMifierCodeVisitor
extends PrintCodeVisitor {
    private final HashMap labelNames = new HashMap();

    public void printInsn(int n) {
        this.buf.append("cv.visitInsn(").append(OPCODES[n]).append(");\n");
    }

    public void printIntInsn(int n, int n2) {
        this.buf.append("cv.visitIntInsn(").append(OPCODES[n]).append(", ").append(n2).append(");\n");
    }

    public void printVarInsn(int n, int n2) {
        this.buf.append("cv.visitVarInsn(").append(OPCODES[n]).append(", ").append(n2).append(");\n");
    }

    public void printTypeInsn(int n, String string) {
        this.buf.append("cv.visitTypeInsn(").append(OPCODES[n]).append(", ");
        ASMifierClassVisitor.appendConstant(this.buf, string);
        this.buf.append(");\n");
    }

    public void printFieldInsn(int n, String string, String string2, String string3) {
        this.buf.append("cv.visitFieldInsn(").append(OPCODES[n]).append(", ");
        ASMifierClassVisitor.appendConstant(this.buf, string);
        this.buf.append(", ");
        ASMifierClassVisitor.appendConstant(this.buf, string2);
        this.buf.append(", ");
        ASMifierClassVisitor.appendConstant(this.buf, string3);
        this.buf.append(");\n");
    }

    public void printMethodInsn(int n, String string, String string2, String string3) {
        this.buf.append("cv.visitMethodInsn(").append(OPCODES[n]).append(", ");
        ASMifierClassVisitor.appendConstant(this.buf, string);
        this.buf.append(", ");
        ASMifierClassVisitor.appendConstant(this.buf, string2);
        this.buf.append(", ");
        ASMifierClassVisitor.appendConstant(this.buf, string3);
        this.buf.append(");\n");
    }

    public void printJumpInsn(int n, Label label) {
        this.declareLabel(label);
        this.buf.append("cv.visitJumpInsn(").append(OPCODES[n]).append(", ");
        this.appendLabel(label);
        this.buf.append(");\n");
    }

    public void printLabel(Label label) {
        this.declareLabel(label);
        this.buf.append("cv.visitLabel(");
        this.appendLabel(label);
        this.buf.append(");\n");
    }

    public void printLdcInsn(Object object) {
        this.buf.append("cv.visitLdcInsn(");
        ASMifierClassVisitor.appendConstant(this.buf, object);
        this.buf.append(");\n");
    }

    public void printIincInsn(int n, int n2) {
        this.buf.append("cv.visitIincInsn(").append(n).append(", ").append(n2).append(");\n");
    }

    public void printTableSwitchInsn(int n, int n2, Label label, Label[] labelArray) {
        int n3;
        for (n3 = 0; n3 < labelArray.length; ++n3) {
            this.declareLabel(labelArray[n3]);
        }
        this.declareLabel(label);
        this.buf.append("cv.visitTableSwitchInsn(").append(n).append(", ").append(n2).append(", ");
        this.appendLabel(label);
        this.buf.append(", new Label[] {");
        for (n3 = 0; n3 < labelArray.length; ++n3) {
            this.buf.append(n3 == 0 ? " " : ", ");
            this.appendLabel(labelArray[n3]);
        }
        this.buf.append(" });\n");
    }

    public void printLookupSwitchInsn(Label label, int[] nArray, Label[] labelArray) {
        int n;
        for (n = 0; n < labelArray.length; ++n) {
            this.declareLabel(labelArray[n]);
        }
        this.declareLabel(label);
        this.buf.append("cv.visitLookupSwitchInsn(");
        this.appendLabel(label);
        this.buf.append(", new int[] {");
        for (n = 0; n < nArray.length; ++n) {
            this.buf.append(n == 0 ? " " : ", ").append(nArray[n]);
        }
        this.buf.append(" }, new Label[] {");
        for (n = 0; n < labelArray.length; ++n) {
            this.buf.append(n == 0 ? " " : ", ");
            this.appendLabel(labelArray[n]);
        }
        this.buf.append(" });\n");
    }

    public void printMultiANewArrayInsn(String string, int n) {
        this.buf.append("cv.visitMultiANewArrayInsn(");
        ASMifierClassVisitor.appendConstant(this.buf, string);
        this.buf.append(", ").append(n).append(");\n");
    }

    public void printTryCatchBlock(Label label, Label label2, Label label3, String string) {
        this.buf.append("cv.visitTryCatchBlock(");
        this.appendLabel(label);
        this.buf.append(", ");
        this.appendLabel(label2);
        this.buf.append(", ");
        this.appendLabel(label3);
        this.buf.append(", ");
        ASMifierClassVisitor.appendConstant(this.buf, string);
        this.buf.append(");\n");
    }

    public void printMaxs(int n, int n2) {
        this.buf.append("cv.visitMaxs(").append(n).append(", ").append(n2).append(");\n");
    }

    public void printLocalVariable(String string, String string2, Label label, Label label2, int n) {
        this.buf.append("cv.visitLocalVariable(");
        ASMifierClassVisitor.appendConstant(this.buf, string);
        this.buf.append(", ");
        ASMifierClassVisitor.appendConstant(this.buf, string2);
        this.buf.append(", ");
        this.appendLabel(label);
        this.buf.append(", ");
        this.appendLabel(label2);
        this.buf.append(", ").append(n).append(");\n");
    }

    public void printLineNumber(int n, Label label) {
        this.buf.append("cv.visitLineNumber(").append(n).append(", ");
        this.appendLabel(label);
        this.buf.append(");\n");
    }

    public void printAttribute(Attribute attribute) {
        if (attribute instanceof ASMifiable) {
            this.buf.append("// CODE ATTRIBUTE\n");
            ((ASMifiable)attribute).asmify(this.buf, "cv", this.labelNames);
        } else {
            this.buf.append("// WARNING! skipped a non standard code attribute of type \"");
            this.buf.append(attribute.type).append("\"\n");
        }
    }

    private void declareLabel(Label label) {
        String string = (String)this.labelNames.get(label);
        if (string == null) {
            string = "l" + this.labelNames.size();
            this.labelNames.put(label, string);
            this.buf.append("Label ").append(string).append(" = new Label();\n");
        }
    }

    private void appendLabel(Label label) {
        this.buf.append((String)this.labelNames.get(label));
    }
}

