/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.encryption;

import java.util.ArrayList;
import java.util.List;
import org.opensaml.xml.encryption.DataReference;
import org.opensaml.xml.encryption.EncryptedData;
import org.opensaml.xml.encryption.EncryptedKey;
import org.opensaml.xml.encryption.EncryptedKeyResolver;
import org.opensaml.xml.security.keyinfo.KeyInfoHelper;
import org.opensaml.xml.util.DatatypeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEncryptedKeyResolver
implements EncryptedKeyResolver {
    private final List<String> recipients = new ArrayList<String>();

    @Override
    public List<String> getRecipients() {
        return this.recipients;
    }

    protected boolean matchRecipient(String recipient) {
        String trimmedRecipient = DatatypeHelper.safeTrimOrNullString(recipient);
        if (trimmedRecipient == null || this.recipients.isEmpty()) {
            return true;
        }
        return this.recipients.contains(trimmedRecipient);
    }

    protected boolean matchCarriedKeyName(EncryptedData encryptedData, EncryptedKey encryptedKey) {
        if (encryptedKey.getCarriedKeyName() == null || DatatypeHelper.isEmpty(encryptedKey.getCarriedKeyName().getValue())) {
            return true;
        }
        if (encryptedData.getKeyInfo() == null || encryptedData.getKeyInfo().getKeyNames().isEmpty()) {
            return false;
        }
        String keyCarriedKeyName = encryptedKey.getCarriedKeyName().getValue();
        List<String> dataKeyNames = KeyInfoHelper.getKeyNames(encryptedData.getKeyInfo());
        return dataKeyNames.contains(keyCarriedKeyName);
    }

    protected boolean matchDataReference(EncryptedData encryptedData, EncryptedKey encryptedKey) {
        if (encryptedKey.getReferenceList() == null || encryptedKey.getReferenceList().getDataReferences().isEmpty()) {
            return true;
        }
        if (DatatypeHelper.isEmpty(encryptedData.getID())) {
            return false;
        }
        List<DataReference> drlist = encryptedKey.getReferenceList().getDataReferences();
        for (DataReference dr : drlist) {
            if (DatatypeHelper.isEmpty(dr.getURI()) || !dr.getURI().startsWith("#") || dr.resolveIDFromRoot(dr.getURI().substring(1)) != encryptedData) continue;
            return true;
        }
        return false;
    }
}

