/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.jndi;

import java.util.Hashtable;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.ldap.Control;
import javax.naming.ldap.ExtendedRequest;
import javax.naming.ldap.ExtendedResponse;
import javax.naming.ldap.LdapContext;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.authn.LdapPrincipal;
import org.apache.directory.server.core.entry.ServerBinaryValue;
import org.apache.directory.server.core.entry.ServerStringValue;
import org.apache.directory.server.core.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.interceptor.context.UnbindOperationContext;
import org.apache.directory.server.core.jndi.JndiUtils;
import org.apache.directory.server.core.jndi.ServerContext;
import org.apache.directory.server.core.jndi.ServerDirContext;
import org.apache.directory.shared.ldap.NotImplementedException;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerLdapContext
extends ServerDirContext
implements LdapContext {
    public ServerLdapContext(DirectoryService service, Hashtable<String, Object> env) throws Exception {
        super(service, env);
    }

    public ServerLdapContext(DirectoryService service, LdapPrincipal principal, LdapDN dn) throws Exception {
        super(service, principal, (Name)dn);
    }

    public ServerLdapContext(DirectoryService service, CoreSession session, LdapDN bindDn) throws Exception {
        super(service, session, bindDn);
    }

    @Override
    public ExtendedResponse extendedOperation(ExtendedRequest request) {
        throw new NotImplementedException();
    }

    @Override
    public LdapContext newInstance(Control[] requestControls) throws NamingException {
        ServerLdapContext ctx = null;
        try {
            ctx = new ServerLdapContext(this.getService(), this.getSession().getEffectivePrincipal(), (LdapDN)this.getDn());
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
        }
        ctx.setRequestControls(requestControls);
        return ctx;
    }

    @Override
    public void reconnect(Control[] connCtls) throws NamingException {
        this.connectControls = connCtls;
    }

    @Override
    public Control[] getConnectControls() throws NamingException {
        return this.connectControls;
    }

    @Override
    public void setRequestControls(Control[] requestControls) throws NamingException {
        this.requestControls = requestControls;
    }

    @Override
    public Control[] getRequestControls() throws NamingException {
        return this.requestControls;
    }

    @Override
    public Control[] getResponseControls() throws NamingException {
        return this.responseControls;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean compare(LdapDN name, String oid, Object value) throws NamingException {
        ServerStringValue val = null;
        AttributeType attributeType = this.getService().getRegistries().getAttributeTypeRegistry().lookup(oid);
        if (attributeType.getSyntax().isHumanReadable()) {
            if (value instanceof String) {
                val = new ServerStringValue(attributeType, (String)value);
            } else {
                if (!(value instanceof byte[])) throw new NamingException("Bad value for the OID " + oid);
                val = new ServerStringValue(attributeType, StringTools.utf8ToString((byte[])((byte[])value)));
            }
        } else if (value instanceof String) {
            val = new ServerBinaryValue(attributeType, StringTools.getBytesUtf8((String)((String)value)));
        } else {
            if (!(value instanceof byte[])) throw new NamingException("Bad value for the OID " + oid);
            val = new ServerBinaryValue(attributeType, (byte[])value);
        }
        CompareOperationContext opCtx = new CompareOperationContext(this.getSession(), name, oid, (Value)val);
        opCtx.addRequestControls(this.requestControls);
        this.injectReferralControl((OperationContext)opCtx);
        boolean result = false;
        try {
            result = super.getDirectoryService().getOperationManager().compare(opCtx);
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
        }
        this.responseControls = this.getResponseControls();
        this.requestControls = EMPTY_CONTROLS;
        return result;
    }

    public void ldapUnbind() throws NamingException {
        LdapDN principalDn = this.getSession().getEffectivePrincipal().getJndiName();
        UnbindOperationContext opCtx = new UnbindOperationContext(this.getSession());
        opCtx.addRequestControls(this.requestControls);
        try {
            super.getDirectoryService().getOperationManager().unbind(opCtx);
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
        }
        this.responseControls = opCtx.getResponseControls();
        this.requestControls = EMPTY_CONTROLS;
    }

    @Override
    public ServerContext getRootContext() throws NamingException {
        ServerLdapContext ctx = null;
        try {
            ctx = new ServerLdapContext(this.getService(), this.getSession().getEffectivePrincipal(), new LdapDN());
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
        }
        return ctx;
    }
}

