/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.jndi;

import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InvalidSearchFilterException;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.event.EventDirContext;
import javax.naming.event.NamingListener;
import javax.naming.spi.DirStateFactory;
import javax.naming.spi.DirectoryManager;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.authn.LdapPrincipal;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.entry.ServerEntryUtils;
import org.apache.directory.server.core.event.DirectoryListener;
import org.apache.directory.server.core.event.NotificationCriteria;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.jndi.EventListenerAdapter;
import org.apache.directory.server.core.jndi.JavaLdapSupport;
import org.apache.directory.server.core.jndi.JndiUtils;
import org.apache.directory.server.core.jndi.NamingEnumerationAdapter;
import org.apache.directory.server.core.jndi.ServerContext;
import org.apache.directory.server.core.jndi.ServerLdapContext;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.ClientBinaryValue;
import org.apache.directory.shared.ldap.entry.client.ClientStringValue;
import org.apache.directory.shared.ldap.filter.AndNode;
import org.apache.directory.shared.ldap.filter.EqualityNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.FilterParser;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.filter.SearchScope;
import org.apache.directory.shared.ldap.message.AliasDerefMode;
import org.apache.directory.shared.ldap.name.AttributeTypeAndValue;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.apache.directory.shared.ldap.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServerDirContext
extends ServerContext
implements EventDirContext {
    public ServerDirContext(DirectoryService service, Hashtable<String, Object> env) throws Exception {
        super(service, env);
    }

    public ServerDirContext(DirectoryService service, LdapPrincipal principal, Name dn) throws Exception {
        super(service, principal, dn);
    }

    public ServerDirContext(DirectoryService service, CoreSession session, LdapDN bindDn) throws Exception {
        super(service, session, (Name)bindDn);
    }

    @Override
    public Attributes getAttributes(String name) throws NamingException {
        return this.getAttributes((Name)new LdapDN(name));
    }

    @Override
    public Attributes getAttributes(Name name) throws NamingException {
        Attributes attrs = null;
        try {
            attrs = ServerEntryUtils.toBasicAttributes((ServerEntry)this.doLookupOperation(this.buildTarget(name)));
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
        }
        return attrs;
    }

    @Override
    public Attributes getAttributes(String name, String[] attrIds) throws NamingException {
        return this.getAttributes((Name)new LdapDN(name), attrIds);
    }

    @Override
    public Attributes getAttributes(Name name, String[] attrIds) throws NamingException {
        Attributes attrs = null;
        try {
            attrs = ServerEntryUtils.toBasicAttributes((ServerEntry)this.doLookupOperation(this.buildTarget(name), attrIds));
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
        }
        return attrs;
    }

    @Override
    public void modifyAttributes(String name, int modOp, Attributes attrs) throws NamingException {
        this.modifyAttributes((Name)new LdapDN(name), modOp, AttributeUtils.toCaseInsensitive((Attributes)attrs));
    }

    @Override
    public void modifyAttributes(Name name, int modOp, Attributes attrs) throws NamingException {
        ArrayList<ModificationItem> modItems = null;
        if (attrs != null) {
            modItems = new ArrayList<ModificationItem>(attrs.size());
            NamingEnumeration<? extends Attribute> e = attrs.getAll();
            while (e.hasMore()) {
                modItems.add(new ModificationItem(modOp, e.next()));
            }
        }
        List newMods = ServerEntryUtils.convertToServerModification(modItems, (AttributeTypeRegistry)this.getDirectoryService().getRegistries().getAttributeTypeRegistry());
        try {
            if (name instanceof LdapDN) {
                this.doModifyOperation(this.buildTarget(name), newMods);
            } else {
                this.doModifyOperation(this.buildTarget((Name)new LdapDN(name)), newMods);
            }
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
        }
    }

    @Override
    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
        this.modifyAttributes((Name)new LdapDN(name), mods);
    }

    @Override
    public void modifyAttributes(Name name, ModificationItem[] mods) throws NamingException {
        List newMods = ServerEntryUtils.toServerModification((ModificationItem[])mods, (AttributeTypeRegistry)this.getDirectoryService().getRegistries().getAttributeTypeRegistry());
        try {
            this.doModifyOperation(this.buildTarget((Name)new LdapDN(name)), newMods);
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
        }
    }

    public void modifyAttributes(Name name, List<ModificationItem> mods) throws NamingException {
        List newMods = ServerEntryUtils.convertToServerModification(mods, (AttributeTypeRegistry)this.getDirectoryService().getRegistries().getAttributeTypeRegistry());
        try {
            this.doModifyOperation(this.buildTarget((Name)new LdapDN(name)), newMods);
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
        }
    }

    @Override
    public void bind(String name, Object obj, Attributes attrs) throws NamingException {
        this.bind((Name)new LdapDN(name), obj, AttributeUtils.toCaseInsensitive((Attributes)attrs));
    }

    @Override
    public void bind(Name name, Object obj, Attributes attrs) throws NamingException {
        if (null == obj && null == attrs) {
            throw new NamingException("Both obj and attrs args are null. At least one of these parameters must not be null.");
        }
        if (null == attrs) {
            super.bind(name, obj);
            return;
        }
        LdapDN target = this.buildTarget(name);
        ServerEntry serverEntry = ServerEntryUtils.toServerEntry((Attributes)AttributeUtils.toCaseInsensitive((Attributes)attrs), (LdapDN)target, (Registries)this.getDirectoryService().getRegistries());
        if (null == obj) {
            ServerEntry clone = (ServerEntry)serverEntry.clone();
            try {
                this.doAddOperation(target, clone);
            }
            catch (Exception e) {
                JndiUtils.wrap(e);
            }
            return;
        }
        DirStateFactory.Result res = DirectoryManager.getStateToBind(obj, name, this, this.getEnvironment(), attrs);
        ServerEntry outServerEntry = ServerEntryUtils.toServerEntry((Attributes)res.getAttributes(), (LdapDN)target, (Registries)this.getDirectoryService().getRegistries());
        if (outServerEntry != serverEntry) {
            ServerEntry clone = (ServerEntry)serverEntry.clone();
            if (outServerEntry != null && outServerEntry.size() > 0) {
                for (EntryAttribute attribute : outServerEntry) {
                    clone.put(new EntryAttribute[]{attribute});
                }
            }
            try {
                this.doAddOperation(target, clone);
            }
            catch (Exception e) {
                JndiUtils.wrap(e);
            }
            return;
        }
        if (obj instanceof Referenceable) {
            throw new NamingException("Do not know how to store Referenceables yet!");
        }
        if (obj instanceof Reference) {
            throw new NamingException("Do not know how to store References yet!");
        }
        if (obj instanceof Serializable) {
            ServerEntry clone = (ServerEntry)serverEntry.clone();
            if (outServerEntry != null && outServerEntry.size() > 0) {
                for (EntryAttribute attribute : outServerEntry) {
                    clone.put(new EntryAttribute[]{attribute});
                }
            }
            JavaLdapSupport.serialize(serverEntry, obj, this.getDirectoryService().getRegistries());
            try {
                this.doAddOperation(target, clone);
            }
            catch (Exception e) {
                JndiUtils.wrap(e);
            }
        } else if (obj instanceof DirContext) {
            ServerEntry entry = ServerEntryUtils.toServerEntry((Attributes)((DirContext)obj).getAttributes(""), (LdapDN)target, (Registries)this.getDirectoryService().getRegistries());
            if (outServerEntry != null && outServerEntry.size() > 0) {
                for (EntryAttribute attribute : outServerEntry) {
                    entry.put(new EntryAttribute[]{attribute});
                }
            }
            try {
                this.doAddOperation(target, entry);
            }
            catch (Exception e) {
                JndiUtils.wrap(e);
            }
        } else {
            throw new NamingException("Can't find a way to bind: " + obj);
        }
    }

    @Override
    public void rebind(String name, Object obj, Attributes attrs) throws NamingException {
        this.rebind((Name)new LdapDN(name), obj, AttributeUtils.toCaseInsensitive((Attributes)attrs));
    }

    @Override
    public void rebind(Name name, Object obj, Attributes attrs) throws NamingException {
        LdapDN target = this.buildTarget(name);
        try {
            if (this.getDirectoryService().getOperationManager().hasEntry(new EntryOperationContext(this.getSession(), target))) {
                this.doDeleteOperation(target);
            }
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
        }
        this.bind(name, obj, AttributeUtils.toCaseInsensitive((Attributes)attrs));
    }

    @Override
    public DirContext createSubcontext(String name, Attributes attrs) throws NamingException {
        return this.createSubcontext((Name)new LdapDN(name), AttributeUtils.toCaseInsensitive((Attributes)attrs));
    }

    @Override
    public DirContext createSubcontext(Name name, Attributes attrs) throws NamingException {
        if (null == attrs) {
            return (DirContext)super.createSubcontext(name);
        }
        LdapDN target = this.buildTarget(name);
        Rdn rdn = target.getRdn(target.size() - 1);
        attrs = AttributeUtils.toCaseInsensitive((Attributes)attrs);
        Attributes attributes = (Attributes)attrs.clone();
        if (rdn.size() == 1) {
            String rdnAttribute = rdn.getUpType();
            String rdnValue = (String)rdn.getValue();
            boolean doRdnPut = attributes.get(rdnAttribute) == null;
            doRdnPut = doRdnPut || attributes.get(rdnAttribute).size() == 0;
            boolean bl = doRdnPut = doRdnPut || !attributes.get(rdnAttribute).contains(rdnValue);
            if (doRdnPut) {
                attributes.put(rdnAttribute, rdnValue);
            }
        } else {
            for (AttributeTypeAndValue atav : rdn) {
                boolean doRdnPut = attributes.get(atav.getNormType()) == null;
                doRdnPut = doRdnPut || attributes.get(atav.getNormType()).size() == 0;
                if (!(doRdnPut = doRdnPut || !attributes.get(atav.getNormType()).contains(atav.getNormValue()))) continue;
                attributes.put(atav.getNormType(), atav.getNormValue());
            }
        }
        try {
            ServerEntry serverEntry = ServerEntryUtils.toServerEntry((Attributes)attributes, (LdapDN)target, (Registries)this.getDirectoryService().getRegistries());
            this.doAddOperation(target, serverEntry);
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
        }
        ServerLdapContext ctx = null;
        try {
            ctx = new ServerLdapContext(this.getService(), this.getSession().getEffectivePrincipal(), target);
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
        }
        return ctx;
    }

    @Override
    public DirContext getSchema(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DirContext getSchema(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DirContext getSchemaClassDefinition(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, Attributes matchingAttributes) throws NamingException {
        return this.search((Name)new LdapDN(name), matchingAttributes, null);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, Attributes matchingAttributes) throws NamingException {
        return this.search(name, AttributeUtils.toCaseInsensitive((Attributes)matchingAttributes), null);
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        return this.search((Name)new LdapDN(name), AttributeUtils.toCaseInsensitive((Attributes)matchingAttributes), attributesToReturn);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        SearchControls ctls = new SearchControls();
        LdapDN target = this.buildTarget(name);
        if (null != attributesToReturn) {
            ctls.setReturningAttributes(attributesToReturn);
        }
        if (null == (matchingAttributes = AttributeUtils.toCaseInsensitive((Attributes)matchingAttributes)) || matchingAttributes.size() <= 0) {
            PresenceNode filter = new PresenceNode("objectClass");
            AliasDerefMode aliasDerefMode = AliasDerefMode.getEnum(this.getEnvironment());
            try {
                EntryFilteringCursor cursor = this.doSearchOperation(target, aliasDerefMode, (ExprNode)filter, ctls);
                return new NamingEnumerationAdapter(cursor);
            }
            catch (Exception e) {
                JndiUtils.wrap(e);
            }
        }
        if (matchingAttributes.size() == 1) {
            NamingEnumeration<? extends Attribute> list = matchingAttributes.getAll();
            Attribute attr = list.next();
            list.close();
            if (attr.size() == 1) {
                Object value = attr.get();
                EqualityNode node = value instanceof byte[] ? new EqualityNode(attr.getID(), (Value)new ClientBinaryValue((byte[])value)) : new EqualityNode(attr.getID(), (Value)new ClientStringValue((String)value));
                AliasDerefMode aliasDerefMode = AliasDerefMode.getEnum(this.getEnvironment());
                try {
                    EntryFilteringCursor cursor = this.doSearchOperation(target, aliasDerefMode, (ExprNode)node, ctls);
                    return new NamingEnumerationAdapter(cursor);
                }
                catch (Exception e) {
                    JndiUtils.wrap(e);
                    return null;
                }
            }
        }
        AndNode filter = new AndNode();
        NamingEnumeration<? extends Attribute> list = matchingAttributes.getAll();
        while (list.hasMore()) {
            Attribute attr = list.next();
            if (attr.size() == 0) {
                filter.addNode((ExprNode)new PresenceNode(attr.getID()));
                continue;
            }
            for (int ii = 0; ii < attr.size(); ++ii) {
                Object val = attr.get(ii);
                if (!(val instanceof String)) continue;
                EqualityNode node = new EqualityNode(attr.getID(), (Value)new ClientStringValue((String)val));
                filter.addNode((ExprNode)node);
            }
        }
        AliasDerefMode aliasDerefMode = AliasDerefMode.getEnum(this.getEnvironment());
        try {
            EntryFilteringCursor cursor = this.doSearchOperation(target, aliasDerefMode, (ExprNode)filter, ctls);
            return new NamingEnumerationAdapter(cursor);
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
            return null;
        }
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, String filter, SearchControls cons) throws NamingException {
        return this.search((Name)new LdapDN(name), filter, cons);
    }

    public NamingEnumeration<SearchResult> search(Name name, ExprNode filter, SearchControls cons) throws NamingException {
        LdapDN target = this.buildTarget(name);
        AliasDerefMode aliasDerefMode = AliasDerefMode.getEnum(this.getEnvironment());
        try {
            return new NamingEnumerationAdapter(this.doSearchOperation(target, aliasDerefMode, filter, cons));
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
            return null;
        }
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, String filter, SearchControls cons) throws NamingException {
        ExprNode filterNode;
        LdapDN target = this.buildTarget(name);
        try {
            filterNode = FilterParser.parse((String)filter);
        }
        catch (ParseException pe) {
            InvalidSearchFilterException isfe = new InvalidSearchFilterException("Encountered parse exception while parsing the filter: '" + filter + "'");
            isfe.setRootCause(pe);
            throw isfe;
        }
        AliasDerefMode aliasDerefMode = AliasDerefMode.getEnum(this.getEnvironment());
        try {
            EntryFilteringCursor cursor = this.doSearchOperation(target, aliasDerefMode, filterNode, cons);
            return new NamingEnumerationAdapter(cursor);
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
            return null;
        }
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        return this.search((Name)new LdapDN(name), filterExpr, filterArgs, cons);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        StringBuffer buf = new StringBuffer(filterExpr);
        for (int ii = 0; ii < buf.length(); ++ii) {
            int start;
            try {
                while (ii < buf.length() && '{' != buf.charAt(ii)) {
                    ++ii;
                }
                start = ii;
                while ('}' != buf.charAt(ii)) {
                    ++ii;
                }
            }
            catch (IndexOutOfBoundsException e) {
                break;
            }
            int index = Integer.parseInt(buf.substring(start + 1, ii));
            if (filterArgs[index] instanceof String) {
                buf.replace(start, ii + 1, (String)filterArgs[index]);
                continue;
            }
            if (filterArgs[index] instanceof byte[]) {
                String hexstr = "#" + StringTools.toHexString((byte[])((byte[])filterArgs[index]));
                buf.replace(start, ii + 1, hexstr);
                continue;
            }
            buf.replace(start, ii + 1, filterArgs[index].toString());
        }
        return this.search(name, buf.toString(), cons);
    }

    @Override
    public void addNamingListener(Name name, String filterStr, SearchControls searchControls, NamingListener namingListener) throws NamingException {
        ExprNode filter;
        try {
            filter = FilterParser.parse((String)filterStr);
        }
        catch (Exception e) {
            NamingException e2 = new NamingException("could not parse filter: " + filterStr);
            e2.setRootCause(e);
            throw e2;
        }
        try {
            EventListenerAdapter listener = new EventListenerAdapter((ServerLdapContext)this, namingListener);
            NotificationCriteria criteria = new NotificationCriteria();
            criteria.setFilter(filter);
            criteria.setScope(SearchScope.getSearchScope((SearchControls)searchControls));
            criteria.setAliasDerefMode(AliasDerefMode.getEnum(this.getEnvironment()));
            criteria.setBase(this.buildTarget(name));
            this.getDirectoryService().getEventService().addListener((DirectoryListener)listener);
            this.getListeners().put(namingListener, listener);
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
        }
    }

    @Override
    public void addNamingListener(String name, String filter, SearchControls searchControls, NamingListener namingListener) throws NamingException {
        this.addNamingListener((Name)new LdapDN(name), filter, searchControls, namingListener);
    }

    @Override
    public void addNamingListener(Name name, String filterExpr, Object[] filterArgs, SearchControls searchControls, NamingListener namingListener) throws NamingException {
        StringBuffer buf = new StringBuffer(filterExpr);
        for (int ii = 0; ii < buf.length(); ++ii) {
            while ('{' != buf.charAt(ii)) {
                ++ii;
            }
            int start = ii;
            while ('}' != buf.charAt(ii)) {
                ++ii;
            }
            buf.replace(start, ii + 1, filterArgs[ii].toString());
        }
        this.addNamingListener(name, buf.toString(), searchControls, namingListener);
    }

    @Override
    public void addNamingListener(String name, String filter, Object[] objects, SearchControls searchControls, NamingListener namingListener) throws NamingException {
        this.addNamingListener((Name)new LdapDN(name), filter, objects, searchControls, namingListener);
    }
}

