/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.Evaluator;
import org.apache.directory.shared.ldap.filter.ScopeNode;
import org.apache.directory.shared.ldap.filter.SearchScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubtreeScopeEvaluator<E>
implements Evaluator<ScopeNode, E> {
    private final ScopeNode node;
    private final Long baseId;
    private final boolean baseIsContextEntry;
    private final boolean dereferencing;
    private final Store<E> db;
    private Long contextEntryId;

    public SubtreeScopeEvaluator(Store<E> db, ScopeNode node) throws Exception {
        this.db = db;
        this.node = node;
        if (node.getScope() != SearchScope.SUBTREE) {
            throw new IllegalStateException("ScopeNode is not of subtree scope.");
        }
        this.baseId = db.getEntryId(node.getBaseDn());
        this.baseIsContextEntry = this.getContextEntryId() == this.baseId;
        this.dereferencing = node.getDerefAliases().isDerefInSearching() || node.getDerefAliases().isDerefAlways();
    }

    private Long getContextEntryId() {
        if (this.contextEntryId == null) {
            try {
                this.contextEntryId = this.db.getEntryId(this.db.getSuffix().getNormName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.contextEntryId == null) {
            return 1L;
        }
        return this.contextEntryId;
    }

    public boolean evaluate(IndexEntry<?, E> candidate) throws Exception {
        if (this.baseIsContextEntry || this.baseId.longValue() == candidate.getId().longValue()) {
            return true;
        }
        boolean isDescendant = this.db.getSubLevelIndex().forward((Object)this.baseId, candidate.getId());
        if (!this.isDereferencing()) {
            return isDescendant;
        }
        if (null != this.db.getAliasIndex().reverseLookup(candidate.getId())) {
            return false;
        }
        if (isDescendant) {
            return true;
        }
        return this.db.getSubAliasIndex().forward((Object)this.baseId, candidate.getId());
    }

    public boolean evaluate(Long id) throws Exception {
        boolean isDescendant = this.db.getSubLevelIndex().forward((Object)this.baseId, id);
        if (!this.isDereferencing()) {
            return isDescendant;
        }
        if (null != this.db.getAliasIndex().reverseLookup(id)) {
            return false;
        }
        if (isDescendant) {
            return true;
        }
        return this.db.getSubAliasIndex().forward((Object)this.baseId, id);
    }

    public boolean evaluate(E candidate) throws Exception {
        throw new UnsupportedOperationException("This is too inefficient without getId() on ServerEntry");
    }

    public ScopeNode getExpression() {
        return this.node;
    }

    public Long getBaseId() {
        return this.baseId;
    }

    public boolean isDereferencing() {
        return this.dereferencing;
    }
}

